/*
    A for-loop has two levels of scope, the scope of the whole
    for-loop and the scope of the loop-body. The following for-loops
    show that these two levels of scope really are different.

    To understand these examples, it helps to use the flow
    diagram of a for-loop given on page 221 of the textbook.
*/

public class ForLoopScope
{
   public static void main(String[] args)
   {
      // this for-loop shows that the scope of i is the for-loop
      // (and the loop-body, which is inside the for-loop)
      for( int i=0; i < 2; i++ )
      {
         System.out.println("Loop 1: i = " + i);
      }
      System.out.println(i); // THIS IS AN ERROR

      // in this for-loop, j is in the scope of the
      // loop-body but not in the scope of the for-loop.
      for( int i=0; i < 3; System.out.println("Loop 2: j = " + j) ) //THIS IS AN ERROR
      {
         int j=i;
         i++;
      }

      // the last for-loop and the next for-loop together show that
      // the "adjustment expression" is in the scope of the for-loop
      // but not the scope of the loop-body
      for( int i=0, j; i < 3; System.out.println("Loop 3: j = " + j) )
      {
         j=i;
         i++;
      }

      // explain why the following for-loop acts the way it does
      for( int i=0, j; ++i < 3; System.out.println("Loop 4: j = " + j) )
      {
         j=i;
      }

   }//main

}//ForLoopScope