/*
   This program demonstrates a typical use for a while loop,
   testing user input until it is correct.

   Notice how there are four ways to structure this, two
   ways using a while-loop, one way using a do-while-loop,
   and another way using a for-loop.

   The only one of the four that is not a good way to do this
   is the second version with a while-loop, because it has to
   repeat two exact same lines of code.
*/
import java.util.Scanner;

public class TestUserInput
{
   public static void main( String[] args )
   {
      Scanner keyboard = new Scanner(System.in);

      // 1
      int userInt = -1;  // give the test variable a "dummy" value
      while( userInt <= 0 )
      {
         System.out.print("Please enter a positive integer: ");
         userInt = keyboard.nextInt();
      }
      System.out.println("That took a while. Let's try it again.\n");


      // 2
      System.out.print("Please enter a non negative integer: ");
      userInt = keyboard.nextInt(); //read an initial value into the test variable
      while( userInt <= 0 )
      {
         System.out.print("Please enter a positive integer: ");
         userInt = keyboard.nextInt();
      }
      System.out.println("That took a while. Let's try it again.\n");


      // 3
      do
      {
         System.out.print("Please enter a positive integer: ");
         userInt = keyboard.nextInt();
      }
      while( userInt <= 0 );
      System.out.println("That took a while. Let's try it again.\n");


       // 4
      for(userInt = -1;  userInt <= 0;  )
      {
         System.out.print("Please enter a positive integer: ");
         userInt = keyboard.nextInt();
      }
      System.out.println("That took a while. But let's quit now.\n");

   }//main()
}
