#include <iomanip>

using namespace std;

#include "product.h"

Product::Product(string product_name, double product_price)
{
   name = product_name;
   price = product_price;
}

string Product::get_name() const
{
   return name;
}

double Product::get_price() const
{
   return price;
}

void Product::adjust_price(double amount)
{
   price = price - amount;
}

void print(ostream& out, const Product& p)
{
   out << setw(40) << left << p.get_name()
      << right << fixed << setw(10) << setprecision(2) << p.get_price()
      << endl;
}
