/******************************************************************************
* An IntArraySet is a collection of int numbers.
* A number may appear only one time in a set.
*
* @note
*   (1) The capacity of one of these sets can change after it's created, but
*   the maximum capacity is limited by the amount of free memory on the
*   machine. The constructor, addItem, clone,
*   and union will result in an OutOfMemoryError
*   when free memory is exhausted.
*   <p>
*   (2) A set's capacity cannot exceed the maximum integer 2,147,483,647
*   (Integer.MAX_VALUE). Any attempt to create a larger capacity
*   results in a failure due to an arithmetic overflow.
*   <p>
*   (3) Because of the slow linear algorithms of this
*   class, large sets will have poor performance.
******************************************************************************/
public class IntArraySet implements Cloneable
{
   // Invariant of the IntArraySet class:
   //   1. The number of elements in the set is in the instance variable
   //      manyItems, which is no more than data.length.
   //   2. For an empty set, we do not care what is stored in any of data;
   //      for a non-empty set, the elements in the set are stored in data[0]
   //      through data[manyItems-1], and we dont care whats in the
   //      rest of data.
   private int[ ] data;
   private int manyItems;

   /**
   * Initialize an empty set with an initial capacity of 10.  Note that the
   * addItem method works efficiently (without needing more
   * memory) until this capacity is reached.
   * @param - none
   * @postcondition
   *   This set is empty and has an initial capacity of 10.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for:
   *   new int[10].
   **/
   public IntArraySet( )
   {

   }


   /**
   * Initialize an empty set with a specified initial capacity. Note that the
   * addItem method works efficiently (without needing more
   * memory) until this capacity is reached.
   * @param initialCapacity
   *   the initial capacity of this set
   * @precondition
   *   initialCapacity is non-negative.
   * @postcondition
   *   This set is empty and has the given initial capacity.
   * @exception IllegalArgumentException
   *   Indicates that initialCapacity is negative.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for: new int[initialCapacity].
   **/
   public IntArraySet(int initialCapacity)
   {

   }


   /**
   * Add a new element to this set. If the given element is already
   * in the set, do nothing. If the new element would take this
   * set beyond its current capacity, then the capacity is increased
   * before adding the new element.
   * @param element
   *   the new element that is being inserted
   * @postcondition
   *   A copy of the element has been added to this set, if it is not already in the set.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for increasing the set's capacity.
   * @note
   *   An attempt to increase the capacity beyond
   *   Integer.MAX_VALUE will cause the set to fail with an
   *   arithmetic overflow.
   **/
   public void add(int element)
   {

   }


   /**
   * Add new elements to this set. If any of the given elements is already
   * in the set, that element is ignored. If the new elements would take this
   * set beyond its current capacity, then the capacity is increased
   * in order to add the new elements.
   * @param elements
   *   (a variable-arity argument)
   *   one or more new elements that are being inserted
   * @postcondition
   *   A copy of each new element has been added to this set.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for increasing the set's capacity.
   * @note
   *   An attempt to increase the capacity beyond
   *   Integer.MAX_VALUE will cause the set to fail with an
   *   arithmetic overflow.
   **/
   public void addMany(int... elements)
   {

   }


   /**
   * Add to this set any element of another set that is not already in this set.
   * The result is this set unioned with the other set.
   * @param set2
   *   a set whose elements will be unioned with this set
   * @precondition
   *   The parameter, set2, is not null.
   * @postcondition
   *   The elements from set2 have been unioned with this set.
   * @exception NullPointerException
   *   Indicates that set2 is null.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory to increase the size of this set.
   * @note
   *   An attempt to increase the capacity beyond
   *   Integer.MAX_VALUE will cause an arithmetic overflow
   *   that will cause the set to fail. Such large collections should use
   *   a different set implementation.
   **/
   public void addAll(IntArraySet set2)
   {

   }


   /**
   * Remove from this set any element of another set that is in this set.
   * The result is the other set's elements subtracted from this set.
   * @param set2
   *   a set whose elements will be subtracted from this set
   * @precondition
   *   The parameter, set2, is not null.
   * @postcondition
   *   The elements from set2 have been subtracted with this set.
   * @exception NullPointerException
   *   Indicates that set2 is null.
   **/
   public void subtractAll(IntArraySet set2)
   {

   }


   /**
   * Remove from this set any of its elements that are not contained in another set.
   * The result is this set intersected with the other set
   * @param set2
   *   a set whose elements will be intersected with this set
   * @precondition
   *   The parameter, set2, is not null.
   * @postcondition
   *   This set contains the intersection of itself with set2.
   * @exception NullPointerException
   *   Indicates that set2 is null.
   **/
   public void keepCommonElements(IntArraySet set2)
   {

   }


   /**
   * Generate a copy of this set.
   * @param - none
   * @return
   *   The return value is a copy of this set. Subsequent changes to the
   *   copy will not affect the original, nor vice versa.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for creating the clone.
   **/
   public IntArraySet clone( )
   {  // Clone an IntArraySet object.

   }


   /**
   * Method to determine if a particular element
   * is in this set.
   * @param target
   *   the element that needs to be found in this set
   * @return
   *   true if the target element is in this set, false otherwise
   **/
   public boolean contains(int target)
   {

   }


   /**
   * Change the current capacity of this set.
   * @param minimumCapacity
   *   the new capacity for this set
   * @postcondition
   *   This set's capacity has been changed to at least minimumCapacity.
   *   If the capacity was already at or greater than minimumCapacity,
   *   then the capacity is left unchanged.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for: new int[minimumCapacity].
   **/
   public void ensureCapacity(int minimumCapacity)
   {

   }


   /**
   * Accessor method to get the current capacity of this set.
   * The add method works efficiently (without needing
   * more memory) until this capacity is reached.
   * @param - none
   * @return
   *   the current capacity of this set
   **/
   public int getCapacity( )
   {

   }


   /**
   * Remove a specified element from this set.
   * @param target
   *   the element to be removed from the set
   * @postcondition
   *   If target was found in the set, then the
   *   target has been removed and the method returns true.
   *   Otherwise the set remains unchanged and the method returns false.
   **/
   public boolean remove(int target)
   {

   }


   /**
   * Determine the number of elements in this set.
   * @param - none
   * @return
   *   the number of elements in this set
   **/
   public int size( )
   {

   }


   /**
   * Reduce the current capacity of this set to its actual size (i.e., the
   * number of elements it contains).
   * @param - none
   * @postcondition
   *   This set's capacity has been changed to its current size.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for altering the capacity.
   **/
   public void trimToSize( )
   {

   }


   /**
   * Create a new set that contains all the elements from this set and one other set.
   * @param set2
   *   the second set in the union
   * @precondition
   *   set2 is not null, and
   *   getCapacity( ) + set2.getCapacity( ) &lt;= Integer.MAX_VALUE.
   * @return
   *   the union of this set and set2
   * @exception NullPointerException.
   *   Indicates that the argument is null.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for the new set.
   * @note
   *   An attempt to create a set with a capacity beyond
   *   Integer.MAX_VALUE will cause an arithmetic overflow
   *   that will cause the set to fail. Such large collections should use
   *   a different set implementation.
   **/
   public IntArraySet union(IntArraySet set2)
   {
      // If set2 is null, then a NullPointerException is thrown.
      // In the case that the total number of items is beyond
      // Integer.MAX_VALUE, there will be an arithmetic overflow and
      // the set will fail.


   }


   /**
   * Create a new set that contains all the elements that are in both this set and one other set.
   * @param set2
   *   the second set in the intersection
   * @precondition
   *   set2 is not null
   * @postcondition
   *   the returned set is smaller than either this set or set2
   * @return
   *   the intersection of this set and set2
   * @exception NullPointerException.
   *   Indicates that the argument is null.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for the new set.
   **/
   public IntArraySet intersection(IntArraySet set2)
   {
      // If set2 is null, then a NullPointerException is thrown.


   }


   /**
   * Create a new set that contains all the elements from this set except those from the other set.
   * @param set2
   *   the second set in the subtraction
   * @precondition
   *   set2 is not null
   * @postcondition
   *   the returned set is smaller than either this set or set2
   * @return
   *   the subtraction of set2 from this set
   * @exception NullPointerException.
   *   Indicates that the argument is null.
   * @exception OutOfMemoryError
   *   Indicates insufficient memory for the new set.
   **/
   public IntArraySet minus(IntArraySet set2)
   {
      // If set2 is null, then a NullPointerException is thrown.


   }


   public String toString()
   {
      String result = "{";
      for (int i = 0; i < manyItems; i++)
      {
         if (i > 0)
         {
            result += " ";
         }
         result += data[i];
         if (i < manyItems-1)
         {
            result += ",";
         }
      }
      result += "}";
      return result;
   }

}//IntArraySet