/*
    Launch the Chrome browser and have it search for the term from the command line.
*/
#include <windows.h>
#include <stdio.h>

// function prototype
void printError(char* functionName);

int main( int argc, char *argv[])
{
   int i;
   char lpCommandLine[256];
   PROCESS_INFORMATION processInfo;
   STARTUPINFO startInfo;
   ZeroMemory(&startInfo, sizeof(startInfo));
   startInfo.cb = sizeof(startInfo);

   /* check for command-line arguments */
   if (argc < 2)
   {
      fprintf(stderr, "Usage: %s <search+term>", argv[0]);
      exit(1);
   }

   /* set up the command line */
   /* first is the path to the chrome.exe program */
   sprintf(lpCommandLine, "%s\\Google\\Chrome\\Application\\chrome.exe", getenv("ProgramFiles(x86)"));
   /* then the URL for a google search */
   sprintf(lpCommandLine, "%s google.com\\#q=", lpCommandLine);
   /* then add the command-line arguments as a search term */
   for (i = 1; i < argc; i++)
   {
      sprintf(lpCommandLine, "%s+%s", lpCommandLine, argv[i]);
   }
   /* We are feeling lucky */
   sprintf(lpCommandLine, "%s%s", lpCommandLine, "&btnI=I%27m+Feeling+Lucky");

   /* Print the command line so that we can see it */
   fprintf(stderr, "%s\n", lpCommandLine );

   /* use the command line with CreateProcess to launch Chrome */
   if( !CreateProcess(NULL, lpCommandLine, NULL, NULL, FALSE,
                      NORMAL_PRIORITY_CLASS | CREATE_NEW_CONSOLE,
                      NULL, NULL, &startInfo, &processInfo) )
   {
      printError("CreateProcess");
   }
   else
   {
      printf("Started Chrome with pid = %d\n\n", (int)processInfo.dwProcessId);
      // close the handles since we do not need them
      CloseHandle(processInfo.hThread);
      CloseHandle(processInfo.hProcess);
   }

   return 0;
}



/****************************************************************
   The following function can be used to print out "meaningful"
   error messages. If you call a Win32 function and it returns
   with an error condition, then call this function right away and
   pass it a string containing the name of the Win32 function that
   failed. This function will print out a reasonable text message
   explaining the error and then (if chosen) terminate the program.
*/
void printError(char* functionName)
{
   LPVOID lpMsgBuf;
   int error_no;
   error_no = GetLastError();
   FormatMessage(
         FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
         NULL,
         error_no,
         MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
         (LPTSTR) &lpMsgBuf,
         0,
         NULL
   );
   // Display the string.
   fprintf(stderr, "\n%s failed on error %d: ", functionName, error_no);
   fprintf(stderr, (char*)lpMsgBuf);
   // Free the buffer.
   LocalFree( lpMsgBuf );
   //ExitProcess(1);  // terminate the program
}//printError
