val a = 3;

(* Where (and when) does ML get a value for a? *)

val f = (fn x => x + a); (* f is a function with a "non local referenece". *)

f(0);

val a = 4;

f(0);

(* With "dynamic scoping", the next result would be -4. *)
let
  val a = ~4
in
  f(0)
end;


(* In the following definition, g is bound to the lambda expression that
   is returned by the let expression. The let expression does NOT
   return (fn x => x + -3), it returns (fn x => x + a) with
   some extra information that specifies what `a' is bound to.
   (So g, like f, is a function with a "non local reference".)
   The extra information about the binding of `a' is called a "closure".
*)
val g = let val a = ~3 in (fn x => x + a) end;

g(0);

val a = 5;

g(0);


(* In the following definition, h is bound to a lambda expression that
   returns another lambda expression. The inner lambda expression is a
   function that, like f and g, makes a "non local reference". But in this
   case, the non local reference is bound to a parameter of the outer lambda
   expression. The result is just a curried version of the + operator.
*)
val h = fn a => (fn x => x + a);

h 7 8;

(h 7) 8;

h(7) 8;

(* In each of the definitions for f, g, and h, there was the
   lambda expression (fn x => x + a). In each of these examples,
   the "non local reference" a get its binding from a different
   place. In f, a was bound to a "top level" variable. In g, a
   was bound to a local variable. In g, a was bound to an outer
   function's parameter variable. One thing that is important to
   notice is that in all three cases, the same rule was used to
   determine the binding for a. The rule used is the "lexical scoping rule".
*)