/**
   This program converts a BTree data structure into
   a DOT description of the tree. The DOT description
   can then be processed by the dot.exe command to
   produce a graphical image of the tree data struncture.

   Create a png file (from a dot file) with the following
   command line
   > dot.exe -Tpng -O tree.dot

   See
   http://www.graphviz.org/Documentation.php
*/

public class BTree2dot
{
   private static int nodeCount;

   public static String btree2dot(BTree bTree)
   {
      String result = "graph {\n";
      result += "node0 [label=\"" + bTree.getElement() + "\"];\n";
      nodeCount = 0;
      result += btree2dot(bTree, nodeCount);
      result += "}\n";
      return result;
   }


   /**
      This btree2dot() method is essentially a
      preorder traversal of the tree.
   */
   public static String btree2dot(BTree bTree, int nodeNumber)
   {
      String result = "";

      if (bTree.getLeftTree() == null)
      {
         // create a new, invisible, node
         result += "node" + (nodeCount+1) + " [style=\"invisible\"];\n";
         // create an invisible edge
         result += "node" + nodeNumber + " -- " + "node" + (nodeCount+1);
         result += " [style=\"invisible\"];\n";
      }
      else
      {
         // create a new node
         result += "node" + (nodeCount+1) + " ";
         result += "[label=\"" + bTree.getLeftTree().getElement() + "\"];\n";
         // create an edge
         result += "node" + nodeNumber + " -- " + "node" + (nodeCount+1) + ";\n";
      }

      if (bTree.getRightTree() == null)
      {
         // create a new, invisible, node
         result += "node" + (nodeCount+2) + " [style=\"invisible\"];\n";
         // create an invisible edge
         result += "node" + nodeNumber + " -- " + "node" + (nodeCount+2);
         result += " [style=\"invisible\"];\n";
      }
      else
      {
         // create a new node
         result += "node" + (nodeCount+2) + " ";
         result += "[label=\"" + bTree.getRightTree().getElement() + "\"];\n";
         // create an edge
         result += "node" + nodeNumber + " -- " + "node" + (nodeCount+2) + ";\n";
      }

      nodeNumber = nodeCount;
      nodeCount += 2;  // count the nodes that we just created

      // convert each sub tree into a dot description
      if ((bTree.getLeftTree() != null) && (bTree.getLeftTree().degree() > 0))
      {
         result += btree2dot(bTree.getLeftTree(),  nodeNumber+1);
      }
      if ((bTree.getRightTree() != null) && (bTree.getRightTree().degree() > 0))
      {
         result += btree2dot(bTree.getRightTree(), nodeNumber+2);
      }
      return result;
   }

}//BTree2dot