/**
   The static method parseExpr0() is a recursive descent parser for
   strings that hold the prefix notation of an arithmetic expression.

   Here is the BNF grammar for prefix notation expressions.

      Prefix -> BinOp Prefix Prefix
              | UnOp Prefix
              | Number

       BinOp -> '+' | '-' | '*' | '/'

       UnOp  -> 'neg' | 'sqrt'

      Number -> any valid Java double

   In a recursive descent parser, every production is handled by a method.
   If a production is recursive, then the method will be recursive.
   If two productions are mutually recursive, then the two methods will
   be mutually recursive. Since this grammar has four productions, the
   parser consists of four methods, getPrefix(), getBinOP(), getUnOp(),
   and getNumber().

   This parser creates an expression tree (that is, an "abstract syntax tree")
   for each prefix expression.
*/

public class ParseExpr0
{
   public static BTree parseExpr0(String expr)
   {
      Tokenizer tokens = new Tokenizer(expr);

      BTree result = getPrefix(tokens); // parse the token stream

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new Error("syntax error: unexpected input: "+tokens.peekToken()+"\n"+tokens);

      return result;
   }//parseExpr0()



   private static BTree getPrefix(Tokenizer tokens)
   {
      BTree result = null;

      String token = tokens.peekToken();  // one token look ahead

      if ( "+-*/^".indexOf(token) != -1 ) // binary operator case
      {
         result = new BTree( getBinOp(tokens),
                             getPrefix(tokens),
                             getPrefix(tokens) );
      }
      else if ( "neg sqrt".indexOf(token) != -1 ) // unary operator case
      {
         result = new BTree( getUnOp(tokens),
                             null,
                             getPrefix(tokens) );
      }
      else // operand case (this case terminates the recursion)
      {
         result = new BTree( getNumber(tokens) );
      }
      return result;
   }//getPrefix()


   private static String getBinOp(Tokenizer tokens)
   {
      return tokens.nextToken(); // consume one token

   }//getBinOp()


   private static String getUnOp(Tokenizer tokens)
   {
      return tokens.nextToken(); // consume one token

   }//getUnOp()


   private static String getNumber(Tokenizer tokens)
   {
      return tokens.nextToken(); // consume one token

   }//getNumber()

}//ParseExpr0
