/**
   The static method parseExpr1() is a recursive descent
   parser for strings that hold the infix notation defined
   by the following BNF grammar.

         Expr -> Term ( '+' | '-' ) Expr | Term

         Term -> Number ( '*' | '/' ) Term | Number

       Number -> any valid Java double

   In a recursive descent parser, every production is handled
   by a method. Since this grammar has three productions, the
   parser consists of three methods, getExpr(), getTerm(),
   and getNumber().

   Input strings are "tokenized" by the very bare bones
   tokenizer contained in the file Tokenizer.java. This
   tokenizer requires that all tokens in the input string
   be surrounded by white space.
*/

public class ParseExpr1
{
   public static BTree parseExpr1(String expr)
   {
      Tokenizer tokens = new Tokenizer(expr);

      BTree result = getExpr(tokens); // parse the token stream

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new Error("syntax error: unexpected input: "+tokens.peekToken()+"\n"+tokens);

      return result;
   }//parseExpr1()



   private static BTree getExpr(Tokenizer tokens)
   {

      return result;
   }//getExpr()


   private static BTree getTerm(Tokenizer tokens)
   {

      return result;
   }//getTerm()


   private static BTree getNumber(Tokenizer tokens)
   {

;      return result;
   }//getNumber()

}//ParseExpr1
