/**
   The static method parseExpr1() is a recursive descent
   parser for strings that hold the infix notation defined
   by the following BNF grammar.

         Expr -> Term ( '+' | '-' ) Expr | Term

         Term -> Number ( '*' | '/' ) Term | Number

       Number -> any valid Java double

   In a recursive descent parser, every production is handled
   by a method. Since this grammar has three productions, the
   parser consists of three methods, getExpr(), getTerm(),
   and getNumber().

   Input strings are "tokenized" by the very bare bones
   tokenizer contained in the file Tokenizer.java. This
   tokenizer requires that all tokens in the input string
   be surrounded by white space.
*/

public class ParseExpr1ParseTree
{
   public static Tree parseExpr1(String expr)
   {
      Tokenizer tokens = new Tokenizer(expr);

      Tree result = getExpr(tokens); // parse the token stream

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new Error("syntax error: unexpected input: "+tokens.peekToken()+"\n"+tokens);

      return result;
   }//parseExpr1()



   private static Tree getExpr(Tokenizer tokens)
   {
      Tree result = new Tree( "Expr" );



      return result;
   }//getExpr()


   private static Tree getTerm(Tokenizer tokens)
   {
      Tree result = new Tree( "Term" );



      return result;
   }//getTerm()


   private static Tree getNumber(Tokenizer tokens)
   {
      Tree result = new Tree( "Number" );



      return result;
   }//getNumber()

}//ParseExpr1ParseTree
