/**
   The static method parseExpr2() is a recursive descent
   parser for strings that hold the infix notation defined
   by the following BNF grammar.

         Expr -> Expr ( '+' | '-' ) Term | Term

         Term -> Term ( '*' | '/' ) Number | Number

       Number -> any valid Java double

   In a recursive descent parser, every production is handled
   by a method. Since this grammar has three productions, the
   parser consists of three methods, getExpr(), getTerm(),
   and getNumber().

   But this grammar is left recursive, so we cannot use it
   to write a recursive descent parser. We need to rewrite
   the grammar in EBNF, and "factor out" the recursion.

         Expr ->   Term ( ('+'|'-') Term )*

         Term -> Number ( ('*'|'/') Number )*

       Number -> any valid Java double

   The Expr and Term productions are now no longer recursive
   (but they are still mutually recursive). The recursion has
   been replaced with "iteration". The getExpr() method should
   use a while-loop to determine how many '+|-' operators it needs
   to parse. And the getTerm() method should also use a while-loop
   to determine how many '*|/' operators it needs to parse.

   Input strings are "tokenized" by the very bare bones
   tokenizer contained in the file Tokenizer.java. This
   tokenizer requires that all tokens in the input string
   be surrounded by white space.
*/

public class ParseExpr2
{
   public static BTree parseExpr2(String expr)
   {
      Tokenizer tokens = new Tokenizer(expr);

      BTree result = getExpr(tokens); // parse the token stream

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new Error("syntax error: unexpected input: "+tokens.peekToken()+"\n"+tokens);

      return result;
   }//parseExpr2()



   private static BTree getExpr(Tokenizer tokens)
   {

      return result;
   }//getExpr()


   private static BTree getTerm(Tokenizer tokens)
   {

      return result;
   }//getTerm()


   private static BTree getNumber(Tokenizer tokens)
   {

       return result;
   }//getNumber()

}//ParseExpr2
