/**
   The static method parseExpr4() is a recursive descent
   parser for strings that hold the infix notation defined
   by the following BNF grammar.

         Expr -> Expr ( '+' | '-' ) Term | Term

         Term -> Term ( '*' | '-' ) Signed | Signed

       Signed -> '-' Factor | Factor

       Factor -> Base '^' Signed | Base

        Base  -> '(' Expr ')' | 'sqrt' Base | Number

       Number -> any valid Java double

   In a recursive descent parser, every production is handled
   by a method. Since this grammar has six productions, the
   parser consists of six methods, getExpr(), getTerm(),
   getSigned(), getFactor(), getBase(), and getNumber().

   But this grammar is left recursive, so we cannot use it
   to write a recursive descent parser. We need to rewrite
   the grammar in EBNF, and "factor out" the recursion.

         Expr ->   Term ( ('+'|'-') Term )*

         Term -> Signed ( ('*'|'/') Signed )*

       Signed -> [ '-' ] Factor

       Factor -> Base [ '^' Signed ]

       Base -> '(' Expr ')' | 'sqrt' Base | Number

       Number -> any valid Java double

   The Expr and Term productions are now no longer recursive
   (but they are still mutually recursive). The recursion has
   been replaced with "iteration". The getExpr() method should
   use a while-loop to determine how many '+|-' operators it needs
   to parse. And the getTerm() method should also use a while-loop
   to determine how many '*|/' operators it needs to parse.

   **NOTE**: To be compatible with the Evaluate.java program from
             Assignment 2, when this parser parses the Signed
             production, it should put the String "neg" into the
             parse tree as the operator, not "-".
*/

public class ParseExpr4
{
   public static BTree parseExpr4(String expr)
   {
      Tokenizer tokens = new Tokenizer(expr);

      BTree result = getExpr(tokens); // parse the token stream

      if ( tokens.hasToken() )  // there shouldn't be any more tokens
         throw new Error("syntax error: unexpected input: "+tokens.peekToken()+"\n"+tokens);

      return result;
   }//parseExpr4()



   private static BTree getExpr(Tokenizer tokens)
   {


      return result;
   }//getExpr()


   private static BTree getTerm(Tokenizer tokens)
   {


      return result;
   }//getTerm()


   private static BTree getSigned(Tokenizer tokens)
   {


      return result;
   }//getSigned()


   private static BTree getFactor(Tokenizer tokens)
   {


      return result;
   }//getFactor()


   private static BTree getBase(Tokenizer tokens)
   {


      return result;
   }//getBase()


   private static BTree getNumber(Tokenizer tokens)
   {

      return result;
   }//getNumber()

}//ParseExpr4
