/*
  This program tests the parsers for language Expr0.
  The language is defined by the following grammar.

       Prefix -> BinOp Prefix Prefix | UnOp Prefix | Number
        BinOp -> '+' | '-' | '*' | '/'
        UnOp  -> 'neg' | 'sqrt'
       Number -> any valid Java double

  This program assumes that you have installed the Graphviz
  package, which includes the dot.exe program. You can
  download the installer for Graphviz and dot.exe from this URL.

    http://www.graphviz.org/pub/graphviz/stable/windows/graphviz-2.28.0.msi

  If you have dot.exe installed and you compile and run this program,
  then for each expression below, this program will create dot files
  for the expression's expression tree (its "abstract syntax tree") and
  its parse tree (its "syntax tree"). and then this program will execute
  the dot.exe program for each dot file and create a png image file of
  the tree described by the dot file.

  You should get image files that look like the files in the folder
    \hw3\png-file\Expr0\
*/

public class TestExpr0
{
   public static void main(String[] args)
   {                   // prefix notation     // parenthesized infix notation
      String prefix[] = { "+ 2 * 3 4",        // 2 + 3 * 4
                          "* + 2 3 4",        // (2 + 3) * 4
                          "+ - 2 3 4",        // 2 - 3 + 4
                          "- 2 + 3 4",        // 2 - (3 + 4)
                          "neg ^ 2 3",        // -2^3
                          "^ neg 2 3",        // (-2)^3
                          "/ + neg -1 sqrt - ^ -1 2 * * 4 1 -1 * 2 1"
                        };

      for (int i = 0; i < prefix.length; i++)
      {
         // Create an abstract syntax tree and a parse tree.
         BTree expTree  = ParseExpr0.parseExpr0( prefix[i] );
         Tree parseTree = ParseExpr0ParseTree.parseExpr0( prefix[i] );

         System.out.println("//        Original expr --> " + prefix[i]);
         System.out.println("// Inline prettyprinted --> " + expTree );
         System.out.println("// The value of this expr = "
                                         + Evaluate.eval( expTree ) + "\n");

         // Create dot and png files from the two trees.
         try
         {
            // Create the dot files.
            java.io.PrintWriter out1 = new java.io.PrintWriter(
                                       new java.io.File("Expr0-"+(i+1)+"-AST.dot") );
            java.io.PrintWriter out2 = new java.io.PrintWriter(
                                       new java.io.File("Expr0-"+(i+1)+"-ParseTree.dot") );
            // Put dot commands into the dot files
            out1.println( BTree2dot.btree2dot(expTree) + "\n" );
            out2.println(  Tree2dot.tree2dot(parseTree) + "\n" );

            out1.close();
            out2.close();
            // Create Windows command lines for running dot.exe. One
            // command line creates a png file for the AST, and the
            // other command line creates a png file for the parse tree.
            String[] cmd1 = {"dot.exe",
                             "-Tpng",
                             "Expr0-"+(i+1)+"-AST.dot",
                             "-o",
                             "Expr0-"+(i+1)+"-AST.png"};
            String[] cmd2 = {"dot.exe",
                             "-Tpng",
                             "Expr0-"+(i+1)+"-ParseTree.dot",
                             "-o",
                             "Expr0-"+(i+1)+"-ParseTree.png"};
            // Execute the two command lines.
            java.lang.Runtime.getRuntime().exec(cmd1);
            java.lang.Runtime.getRuntime().exec(cmd2);
         }
         catch (Exception e)
         {
            System.out.println( e );
         }
      }
   }//main()

}//TestExpr0
