/*
  This program tests your parsers for language Expr2.
  The language is defined by the following BNF grammar,

         Expr -> Expr ('+'|'-')  Term  |  Term
         Term -> Term ('*'|'/') Number | Number
       Number -> any valid Java double

  but we parse the grammar using this EBNF grammar.

         Expr ->   Term ( ('+'|'-') Term   )*
         Term -> Number ( ('*'|'/') Number )*
       Number -> any valid Java double

  This program assumes that you have installed the Graphviz
  package, which includes the dot.exe program. You can
  download the installer for Graphviz and dot.exe from this URL.

    http://www.graphviz.org/pub/graphviz/stable/windows/graphviz-2.28.0.msi

  If you have dot.exe installed and you compile and run this program,
  then for each expression below, this program will create dot files
  for the expression's expression tree (its "abstract syntax tree") and
  its parse tree (its "syntax tree"). and then this program will execute
  the dot.exe program for each dot file and create a png image file of
  the tree described by the dot file.

  You should get image files that look like the files in the folder
    \hw3\png-file\Expr2\
*/

public class TestExpr2
{
   public static void main(String[] args)
   {
      String infix[] = { "5 - 3 - 2", // this language is left associative
                         "4 / 2 / 2",
                         "4 * 3 * 2 + 1",
                         "2 * 3 + 4 + 5 * 6",
                         "2 + 3 + 4 + 5 + 6",
                         "2 / 1 * 2"
                       };

      for (int i = 0; i < infix.length; i++)
      {
         // Create an abstract syntax tree and a parse tree.
         BTree expTree  = ParseExpr2.parseExpr2( infix[i] );
         Tree parseTree = ParseExpr2ParseTree.parseExpr2( infix[i] );

         System.out.println("//        Original expr --> " + infix[i]);
         System.out.println("// Inline prettyprinted --> " + expTree );
         System.out.println("// The value of this expr = "
                                         + Evaluate.eval( expTree ) + "\n");

         // Create dot and png files from the two trees.
         try
         {
            // Create the dot files.
            java.io.PrintWriter out1 = new java.io.PrintWriter(
                                       new java.io.File("Expr2-"+(i+1)+"-AST.dot") );
            java.io.PrintWriter out2 = new java.io.PrintWriter(
                                       new java.io.File("Expr2-"+(i+1)+"-ParseTree.dot") );
            // Put dot commands into the dot files
            out1.println( BTree2dot.btree2dot(expTree) + "\n" );
            out2.println(  Tree2dot.tree2dot(parseTree) + "\n" );

            out1.close();
            out2.close();
            // Create Windows command lines for running dot.exe. One
            // command line creates a png file for the AST, and the
            // other command line creates a png file for the parse tree.
            String[] cmd1 = {"dot.exe",
                             "-Tpng",
                             "Expr2-"+(i+1)+"-AST.dot",
                             "-o",
                             "Expr2-"+(i+1)+"-AST.png"};
            String[] cmd2 = {"dot.exe",
                             "-Tpng",
                             "Expr2-"+(i+1)+"-ParseTree.dot",
                             "-o",
                             "Expr2-"+(i+1)+"-ParseTree.png"};
            // Execute the two command lines.
            java.lang.Runtime.getRuntime().exec(cmd1);
            java.lang.Runtime.getRuntime().exec(cmd2);
         }
         catch (Exception e)
         {
            System.out.println( e );
         }
      }
   }//main()

}//TestExpr2
