/*
  This program tests your parsers for language Expr4, the
  language of infix arithmetic expressions.

        Expr ::=   Term ( ('+'|'-') Term   )*
        Term ::= Signed ( ('*'|'/') Signed )*
      Signed ::= ['-'] Factor
      Factor ::= Base ['^' Signed]
        Base ::= '(' Expr ')' | 'sqrt' Base | Number
      Number ::= any valid Java double

  This program assumes that you have installed the Graphviz
  package, which includes the dot.exe program. You can
  download the installer for Graphviz and dot.exe from this URL.

    http://www.graphviz.org/pub/graphviz/stable/windows/graphviz-2.28.0.msi

  If you have dot.exe installed and you compile and run this program,
  then for each expression below, this program will create dot files
  for the expression's expression tree (its "abstract syntax tree") and
  its parse tree (its "syntax tree"). and then this program will execute
  the dot.exe program for each dot file and create a png image file of
  the tree described by the dot file.

  You should get image files that look like the files in the folder
    \hw3\png-file\Expr4\
*/

public class TestExpr4
{
   public static void main(String[] args)
   {
      String infix[] =
            // parenthesized infix notation
          { "2 + 3 * 4",
            "( 2 + 3 ) * 4",
            "2 - 3 + 4",
            "2 - ( 3 + 4 )",
            "- 2 ^ 3",
            "( - 2 ) ^ 3",
            "3 * sqrt 25 - ( - 6 + 5 ) * - 1",
            "- sqrt ( 6 ^ 2 ) + ( ( 4 ) * ( 2 ) )",
          };


      for (int i = 0; i < infix.length; i++)
      {
         // Create an abstract syntax tree and a parse tree.
         BTree expTree  = ParseExpr4.parseExpr4( infix[i] );
         Tree parseTree = ParseExpr4ParseTree.parseExpr4( infix[i] );

         System.out.println("//        Original expr --> " + infix[i]);
         System.out.println("//   Parenthesized expr --> "
                                         + InfixPrinter.infixPrint( expTree ));
         System.out.println("// Inline prettyprinted --> " + expTree );
         System.out.println("// The value of this expr = "
                                         + Evaluate.eval( expTree ) + "\n");

         // Create dot and png files from the two trees.
         try
         {
            // Create the dot files.
            java.io.PrintWriter out1 = new java.io.PrintWriter(
                                       new java.io.File("Expr4-"+(i+1)+"-AST.dot") );
            java.io.PrintWriter out2 = new java.io.PrintWriter(
                                       new java.io.File("Expr4-"+(i+1)+"-ParseTree.dot") );
            // Put dot commands into the dot files
            out1.println( BTree2dot.btree2dot(expTree) + "\n" );
            out2.println(  Tree2dot.tree2dot(parseTree) + "\n" );

            out1.close();
            out2.close();
            // Create Windows command lines for running dot.exe. One
            // command line creates a png file for the AST, and the
            // other command line creates a png file for the parse tree.
            String[] cmd1 = {"dot.exe",
                             "-Tpng",
                             "Expr4-"+(i+1)+"-AST.dot",
                             "-o",
                             "Expr4-"+(i+1)+"-AST.png"};
            String[] cmd2 = {"dot.exe",
                             "-Tpng",
                             "Expr4-"+(i+1)+"-ParseTree.dot",
                             "-o",
                             "Expr4-"+(i+1)+"-ParseTree.png"};
            // Execute the two command lines.
            java.lang.Runtime.getRuntime().exec(cmd1);
            java.lang.Runtime.getRuntime().exec(cmd2);
         }
         catch (Exception e)
         {
            System.out.println( e );
         }
      }
   }//main()

}//TestExpr4
