/**
   This class defines the nodes for a tree data structure.

   A "label" for each node is stored as a String.

   The subtrees of a node are stored in an ArrayList, so
   a node can have an arbitrary number of subtrees and
   the subtrees are ordered by the index of the ArrayList.
*/
import java.util.ArrayList;

public class Tree
{
   private String element;
   private ArrayList<Tree> subTrees;

   public Tree(String element)
   {
      this.element = element;
      subTrees = null;
   }

   public String getElement()
   {
      return element;
   }

   public Tree getSubTree(int i)
   {
      return subTrees.get(i);
   }

   public void addSubTree(Tree tree)
   {
      if (subTrees == null)
         subTrees = new ArrayList<Tree>();
      subTrees.add( tree );
   }

   /**
      Compute the number of subtrees below this node.
   */
   public int degree()
   {
      if (subTrees == null)
         return 0;
      else
         return subTrees.size();
   }

   /**
      Calculate the depth of the subtree below this node.
   */
   public int depth()
   {
      int result = 0;
      if (degree() > 0)
      {
         int max = 0;
         for (int i = 0; i < degree(); i++)
         {
            int temp = getSubTree(i).depth();
            if (temp > max) max = temp;
         }
         result = 1+max;
      }
      return result;
   }

   /**
      This toString() method is essentially a
      preorder traversal of the tree.
   */
   public String toString()
   {
      String result = "";

      if (depth() == 0)  // depth==0 stops the recursion also
      {
         result += getElement();
      }
      else  // do a preorder traversal
      {
         result += "(" + getElement();
         for (int i = 0; i < degree(); i++)
         {
            Tree t;
            // Notice that this line is implicitly recursive (why?).
            result += " " + (((t=getSubTree(i))!=null) ? t : "()");
         }
         result += ")";
      }
      return result;
   }//toString()

}//Tree
