/*
   This class contains one of the four algorithms for creating a
   random permutation of the integers from 1 to n.
*/
import java.util.Arrays;

public class Permutation1
{


  /*
    This algorithm is medium fast. It is much(!) faster than the slowest algorithm, but not as fast as the fastest one.

    The idea behind this algorithm is that you have a row of n empty array slots in front of you (empty means the array slot contains zero). You take the number 1, and someone gives you a random index for an array slot in which to put 1. Then you take 2 and someone gives you a random index for an array slot in which to put 2, But you need to check that the array slot really is empty (i.e., zero) otherwise you need to be told another array index to try. For each i from 1 to n, you are told a random index for a slot in which to put i, but you need to test if the array slot at that random index is empty first. If the slot is empty, put i in the slot, if the slot isn't empty, ask for a new random array index. When you are done, the numbers from 1 to n have been placed randomly the n slots, giving a random permutation of the numbers from 1 to n.

    This function is O(n) in the best case (as opposed to O(n^2) in the best case for the slowest algorithm). The best case is when the random array index always points to an empty slot. This algorithm eliminates the need for linear searches, which is one of the two things that made the slowest algorithm so slow. The other aspect that made the slowest algorithm slow is still in this algorithm, i.e., this algorithm slows down as i get near to n because it becomes harder to choose a random array index that is for an empty slot.
  */
  public static void permutation(int[] integerArray)
  {
     int n = integerArray.length;

     for (int i = 0; i < n; i++)
        integerArray[i] = 0;  // initialize the array to all zeros

     for (int i = 1; i <= n; i++) // this loop puts i in a randomly chosen slot of the array
     {
       int tryIndex = (int)(n*Math.random()); // pick an array slot randomly
       while( integerArray[tryIndex] != 0 )   // check if the slot is "empty"
           tryIndex = (int)(n*Math.random()); // if not, choose another array slot
       integerArray[tryIndex] = i;            // put i in the "empty" slot
     }
  }//permutation




  public static void main(String[] args)
  {
     int n = Integer.parseInt( args[0] );  // get parameter from command line

     int[] integerArray = new int[n];  // array that will hold the permutation.

     // the permutation() method will fill the array with
     // a random permutation of the integers from 1 to n
     permutation(integerArray);

     // as soon as permutation() is done, print a message.
     System.out.println("\nDone.");

     // if n is small enough, print out the permutation.
     if (n <= 100)
     {
        printTheArray(integerArray);

        Arrays.sort( integerArray );
        // print the sorted array to make sure that all of the integers are there
        printTheArray(integerArray);
     }

  }//main


  /*
     This method prints the array in rows of 10.
  */
  public static void printTheArray(int[] theArray)
  {
     System.out.println("\nHere is the array.\n");
     for (int i = 0; i < theArray.length; i++)
     {
        System.out.print(" " + theArray[i]);
        if ((i+1)%10 == 0) System.out.print("\n");
     }
     System.out.print("\n");
  }//printTheArray

}//Permutation1