/*
   This class contains one of the four algorithms for creating a
   random permutation of the integers from 1 to n.
*/
import java.util.Arrays;

public class Permutation2
{


  /*
    This algorithm is the fastest of the four algorithm. This algorithm is O(n) for both the best case and worst case. In other words, it always runs in order n time. One easy way to see this is that the algorithm has only two loops but they are not nested. So each loop must run in O(n) time (there is nothing that can possibly slow either loop down).

    This algorithm implements what would be the classic way to think of creating a random permutation of the numbers from 1 to n. Take n ping pong balls and paint the numbers from 1 to n on them. Put the n ping pong balls in a large jar. Then reach in and randomly pull out one ball at a time from the jar (without ever putting a ball back in the jar) and write down the number on the ball in an array. The order in which the balls are pulled out is the random permutation.

    The first loop initializes the array to be sorted with the numbers from 1 to n (in a sense, this fills the jar). Notice that in the above description of the algorithm for generating the permutation we need two places to keep ping pong balls, in the jar before they are removed and in an array after they are removed from the jar. The second for-loop uses the array integerArray for both of these storage places. The lower part of the array (from indices 0 to upperBound-1) is the "jar", and the upper part of the array holds the numbers that have been pulled out of the "jar". The second for-loop randomly pulls a number from the "jar" by choosing a random index between 0 and upperBound-1 and then swapping the number at that index into the array slot that is the boundary between the "jar" and the list of drawn numbers. Then upperBound is decremented to denote that the "jar" has shrunk by one slot and the list has grown by one slot.
  */
  public static void permutation(int[] integerArray)
  {
    int n = integerArray.length;

    // initialize the array
    for (int i = 0; i < n; i++)
      integerArray[i] = i+1;

    int upperBound = n;
    // The array from indices 0 to upperBound-1 is the "jar" to draw randomly
    // from, and the array from indices upperBound to n-1 is the list of
    // numbers that have already been drawn out of the "jar".
    for (int i = 0; i < n; i++)
    {
      // pick a slot in the "jar" part of the array
      int randomIndex = (int)(upperBound*Math.random());

      // swap myArray[upperBound-1] with myArray[randomIndex]
      // (that is, move an item from the "jar" part of the array
      // to the list part of the array)
      int temp = integerArray[upperBound-1];
      integerArray[upperBound-1] = integerArray[randomIndex];
      integerArray[randomIndex] = temp;

      // lower the upperbound
      upperBound--;  // lower the boundary of the "jar" part of the array
    }
  }//permutation




  public static void main(String[] args)
  {
     int n = Integer.parseInt( args[0] );  // get parameter from command line

     int[] integerArray = new int[n];  // array that will hold the permutation.

     // the permutation() method will fill the array with
     // a random permutation of the integers from 1 to n
     permutation(integerArray);

     // as soon as permutation() is done, print a message.
     System.out.println("\nDone.");

     // if n is small enough, print out the permutation.
     if (n <= 100)
     {
        printTheArray(integerArray);

        Arrays.sort( integerArray );
        // print the sorted array to make sure that all of the integers are there
        printTheArray(integerArray);
     }

  }//main


  /*
     This method prints the array in rows of 10.
  */
  public static void printTheArray(int[] theArray)
  {
     System.out.println("\nHere is the array.\n");
     for (int i = 0; i < theArray.length; i++)
     {
        System.out.print(" " + theArray[i]);
        if ((i+1)%10 == 0) System.out.print("\n");
     }
     System.out.print("\n");
  }//printTheArray

}//Permutation2