/*
   This class contains one of the four algorithms for creating a
   random permutation of the integers from 1 to n.
*/
import java.util.Arrays;

public class Permutation3
{


  /*
    This is the most simple minded, and also the slowest, of the four permutation algorithms. Suppose the array from indices 0 to i-1 is filled with unique numbers from 1 to n. This algorithm will keep picking random numbers from 1 to n until it finds a number that hasn't been used in the part of the array between indices 0 and i-1 (that is the inner while-loop). This algorithm does a linear search of the array between indices 0 and i to see if the random number is already in the array (that is the inner most for-loop). When the algorithm finds an unused number, it puts it in the array and increments i (that is the outer most for-loop).

    This algorithm, in its best case, is O( (n^2)/2 ). For every iterate of the outer for-loop, there has to be at least one linear search of the array from indices 0 to i-1. To achieve the best case, the while-loop has to always choose in one iterate a random number that is not already in the array. But as the algorithm gets near the end of the array (for i near n) it becomes very improbable that a random number can be chosen in one try that is not already in the array. For example, when i is n-2, there is only one number left from 1 to n that is not yet in the array, but picking this number at random will require an expected n tries of the random number generator. So as the array fills up, this algorithm slows down considerably.

    In summary, this algorithm has two aspects that slow it down, Its best case is order (n^2)/2 because of the (at least) n linear searches needed to check if a number is already in the array. And second, as the array fills up, the number of linear searches needed increases to nearly n for every iterate of the outer for-loop.
  */
  public static void permutation(int[] integerArray)
  {
    int n = integerArray.length;

    integerArray[0] = 1 + (int)(n*Math.random()); // random integer between 1 and n
    // This loop has the invariant that the array from indices 0
    // to i-1 is filled with i unique numbers from 1 to n.
    for (int i = 1; i < n; i++) // puts a random number in the i'th slot of the array
    {
      int tryInteger = 1 + (int)(n*Math.random());// pick a number to put in integerArray[i]
      boolean keepTrying = true;
      while( keepTrying ) // keep picking numbers until we get one that hasn't been used
      {
        // test if tryInteger is already in the array between indices 0 and i-1
        int j;
        for (j = 0; j < i; j++)
          if (integerArray[j] == tryInteger)
            break; // tryInteger was found in the array between indices 0 and i-1
        if (j < i) // test how the last for-loop terminated
          tryInteger = 1 + (int)(n*Math.random()); // tryInteger was found
        else
          keepTrying = false;  // tryInteger wasn't found, so quit the while loop
      }
      // tryInteger wasn't found, so go ahead and put it in the array
      integerArray[i] = tryInteger;
    }
  }//permutation




  public static void main(String[] args)
  {
     int n = Integer.parseInt( args[0] );  // get parameter from command line

     int[] integerArray = new int[n];  // array that will hold the permutation.

     // the permutation() method will fill the array with
     // a random permutation of the integers from 1 to n
     permutation(integerArray);

     // as soon as permutation() is done, print a message.
     System.out.println("\nDone.");

     // if n is small enough, print out the permutation.
     if (n <= 100)
     {
        printTheArray(integerArray);

        Arrays.sort( integerArray );
        // print the sorted array to make sure that all of the integers are there
        printTheArray(integerArray);
     }

  }//main


  /*
     This method prints the array in rows of 10.
  */
  public static void printTheArray(int[] theArray)
  {
     System.out.println("\nHere is the array.\n");
     for (int i = 0; i < theArray.length; i++)
     {
        System.out.print(" " + theArray[i]);
        if ((i+1)%10 == 0) System.out.print("\n");
     }
     System.out.print("\n");
  }//printTheArray

}//Permutation3