/*
   This class contains one of the four algorithms for creating a
   random permutation of the integers from 1 to n.
*/
import java.util.Arrays;

public class Permutation4
{


  /*
    This algorithm is medium fast. It is much(!) faster than the slowest algorithm, but not as fast as the fastest one.

    This algorithm, like the slowest algorithm, starts at the beginning of the array and fills it from beginning to end with randomly chosen numbers. To make sure that a new random number hasn't been used before, the slowest version did a linear search of the filled part of the array. This algorithm keeps an extra array where each number is marked in this extra array as either used or unused. When a new random number is chosen, it is looked up in the extra array to see if the number has been used already. This eliminates the need for the linear searches.

    This function is O(n) in the best case (as opposed to the slowest algorithm which is O(n^2) in the best case). The best case is when each randomly chosen number is an unused number. But this best case is very improbable, since as the array fills up, there are very few unused numbers left. Randomly choosing an unused number becomes very hard as the index i gets close to n.

    So like the slowest algorithm, this algorithm slows down as the array fills up. But this algorithm is much faster than the slowest algorithm because this algorithm can check in constant time whether a randomly chosen number has been used or not.(The slowest algorithm needs linear time to test if a randomly chosen number has been used or not.)
  */
  public static void permutation(int[] integerArray)
  {
    int n = integerArray.length;

    boolean[] testArray = new boolean[n];
    // initialize the other array
    for (int i = 0; i < n; i++)
      testArray[i] = false;    // initially, all of the integers are unused

    // This loop has the invariant that the array from indices 0
    // to i-1 is filled with i unique numbers from 1 to n.
    for (int i = 0; i < n; i++)
    {
      int tryInteger = 1 + (int)(n*Math.random()); // random integer between 1 and n
      while( testArray[tryInteger-1] )           // test if the integer has been used or not
        tryInteger = 1 + (int)(n*Math.random()); // if so, pick another integer
      integerArray[i] = tryInteger;
      testArray[tryInteger-1] = true;  // mark this integer as used
    }
  }//permutation




  public static void main(String[] args)
  {
     int n = Integer.parseInt( args[0] );  // get parameter from command line

     int[] integerArray = new int[n];  // array that will hold the permutation.

     // the permutation() method will fill the array with
     // a random permutation of the integers from 1 to n
     permutation(integerArray);

     // as soon as permutation() is done, print a message.
     System.out.println("\nDone.");

     // if n is small enough, print out the permutation.
     if (n <= 100)
     {
        printTheArray(integerArray);

        Arrays.sort( integerArray );
        // print the sorted array to make sure that all of the integers are there
        printTheArray(integerArray);
     }

  }//main


  /*
     This method prints the array in rows of 10.
  */
  public static void printTheArray(int[] theArray)
  {
     System.out.println("\nHere is the array.\n");
     for (int i = 0; i < theArray.length; i++)
     {
        System.out.print(" " + theArray[i]);
        if ((i+1)%10 == 0) System.out.print("\n");
     }
     System.out.print("\n");
  }//printTheArray

}//Permutation4