/*
   This test function computes the n'th Fibonacci number,
   where n is a command line parameter,
   The time it takes is (roughly) calculated.
*/
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>   // needed for LARGE_INTEGER  and QueryPerformanceCounter()
#include "Timing.h"
#include "Fibonacci.h"

int main(int argc, char** argv)
{
   LARGE_INTEGER timeStart, timeEnd;             // time in clock-ticks
   LARGE_INTEGER clockFrequency;                 // clock-ticks per second
   double elapsedTicks;
   TimingObject startTime, endTime, elapsedTime; // time in milli-seconds
   unsigned long fn;
   int n;
   if (argc > 1)
   {
      n = atoi( argv[1] );  // get parameter from command line
   }
   else
   {
      printf("Usage: Fibonacci <n>");
      return 0;
   }

   // get number of clock ticks per second
   QueryPerformanceFrequency(&clockFrequency);

   // Compute the n'th Fibonacci number.
   getThreadTime( &startTime );           // milli-second timer
   QueryPerformanceCounter( &timeStart ); // clock-tick timer
   fn = Fib1( n );
   QueryPerformanceCounter( &timeEnd );
   getThreadTime( &endTime );

   // Compute the elapsed time.
   elapsedTicks = timeEnd.QuadPart - timeStart.QuadPart;
   computeElapsedTime( &startTime, &endTime, &elapsedTime );

   printf("Fib(%d) = %lu, and it took\n", n, fn);
   printf("\t%f seconds,\n", elapsedTicks/clockFrequency.QuadPart);
   printTimingObject( &elapsedTime );
   printf("to compute the %d'th Fibonacci number.\n", n);

   return 0;
}//main()
