/*

*/

package TimeZoneWebService_v3;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Scanner;

/**
   This program implements a time zone service.

   This program expects a time zone id as a
   String in System.in. The time zone id is
   looked up in Java's built-in list of time
   zones. If the id is found in the list, then
   a String holding that time zone's current
   time is sent to the service client.

   See
   https://docs.oracle.com/en/java/javase//21/docs/api/java.base/java/util/TimeZone.html
*/
public class TimeZoneService
{
   private static final DateFormat timeFormatter = DateFormat.getTimeInstance();

   /**

   */
   public static void main(String[] args)
   {
      // Get the time zone id from System.in.
      String timeZoneId = null;
      try (final Scanner in = new Scanner(System.in))
      {
         timeZoneId = in.nextLine().trim();
      }

      // Look up the time zone d in Java's built-in list of time zones.
      TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);


      final String timeString;
      if (timeZone.getID().equals("GMT") && ! timeZoneId.equals("GMT"))
      {
         timeString = "null";
      }
      else
      {
         timeFormatter.setTimeZone(timeZone);
         final Date time = new Date();
         timeString = timeFormatter.format(time);
      }

      // Log the result.
      System.err.println("=====> INFO: TimeZoneService: time zone id = " + timeZoneId
                                                           + ", time = " + timeString);

      // Send the result.
      System.out.print(timeString + "\n");
      System.out.flush();
      System.out.close();
   }
}
