/*
   Run this program from the command-line and
   redirect its standard output stream to a file.

   > java TestCharacterEncodings > out1.txt

   Run this program nine times and each time
   use a different character encoding and use
   a different name for the output file.

   Notice that the output files change size
   with the changed encodings. Why?
*/

import java.io.PrintWriter;
import java.io.OutputStreamWriter;

public class TestCharacterEncodings
{
   public static void main(String[] args) throws Exception
   {
      final PrintWriter out = new PrintWriter(
                                  new OutputStreamWriter(
                                      System.out, "ASCII")); // Try ISO-8859-1, UTF-8,
                                                             // UTF-16, UTF-16LE ,UTF-16BE,
                                                             // UTF-32, UTF-32LE, UTF-32BE.

      out.print("hello ");  // Ascii.
      out.print("\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087"); // Extended ascii or unicode.
      out.print("\n"); // Two ascii characters on Windows, one ascii character on Linux.
      out.flush();
   }
}

//  https://docs.oracle.com/en/java/javase/21//docs/api/java.base/java/nio/charset/Charset.html#standard
