/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as 16 booleans (each boolean is one byte).

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsBoolean  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsBoolean
*/

import java.io.*;

public class ReadDataAsBoolean
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      final boolean[] b = new boolean[16]; // try 17

      try
      {
         for (int i = 0; i < b.length; ++i)
         {
            b[i] = in.readBoolean();
         }

         for (int i = 0; i < b.length; ++i)
         {
            System.out.println( b[i] );
         }

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //for (int i = 0; i < b.length; ++i)
         //{
         //   out.writeBoolean( b[i] );
         //}
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readBoolean()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readBoolean()
