/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as a short followed by a double followed
   by two bytes followed by an int.

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsShortDoubleBytesInt  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsShortDoubleBytesInt
*/

import java.io.*;

public class ReadDataAsShortDoubleBytesInt
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      try
      {
         final short  n1 = in.readShort();
         final double n2 = in.readDouble();
         final byte   n3 = in.readByte();
         final byte   n4 = in.readByte();
         final int    n5 = in.readInt();

         System.out.println(n1);
         System.out.println(n2);
         System.out.println(n3);
         System.out.println(n4);
         System.out.println(n5);

         // Do the reverse of what we just did.
         //DataOutputStream out = new DataOutputStream(System.out);
         //out.writeShort(n1);
         //out.writeDouble(n2);
         //out.writeByte(n3);
         //out.writeByte(n3);
         //out.writeInt(n5);
         //out.flush();
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html
