/*
   This program reads 16 bytes of data from
   standard input and interprets those bytes
   as unsigned bytes.

   Run this program on the command-line and
   have it read the data file created with
   CreateData.java.

   > java  ReadDataAsUnsignedByte  <  data

   Alternatively, you can pipe the output from
   CreateData directly into this program.

   > java CreateData | java ReadDataAsUnsignedByte
*/

import java.io.*;

public class ReadDataAsUnsignedByte
{
   public static void main(String[] args)
   {
      DataInputStream in = new DataInputStream(System.in);

      final int[] b = new int[16];

      try
      {
         for (int i = 0; i < b.length; ++i)
         {
            b[i] = in.readUnsignedByte(); // Notice that unsigned bytes are ints.
         }

         for (int i = 0; i < b.length; ++i)
         {
            System.out.println(b[i]);
          //System.out.printf("%02X\n", b[i]);
         }
      }
      catch (IOException e)
      {
         System.out.print( e );
      }
   }
}

// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInputStream.html#readUnsignedByte()
// https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/DataInput.html#readUnsignedByte()
