/*
   Try examples like
      >java ParseURI  https://cs.pnw.edu:80/~rlkraft/cs33600/class.html#2025-01-29
      >java ParseURI  https://google.com/search?q=pnw+cs+dept
      >java ParseURI  https://www.google.com:80
      >java ParseURI  https://swapi.dev/api/people/3/?format=json
*/

import java.net.*;

public class Parse_URI
{
   public static void main(String[] args)
   {
      final String uriString;
      if (args.length > 0)
      {
         uriString = args[0];
      }
      else
      {  // Cretae a default URI.
         uriString = "ftp://myUsername:myPassword@example.com:8042/over/there/index.php?type=animal&name=narwhal#nose";
      }

      try
      {
         final URI uri = new URI( uriString );

         // See
         //     https://en.wikipedia.org/wiki/Uniform_Resource_Identifier#Example_URIs
         System.out.println("URI = " + uri);
         System.out.println();
         System.out.println("Scheme = "    + uri.getScheme());
         System.out.println("Authority = " + uri.getAuthority());
         System.out.println("UserInfor = " + uri.getUserInfo());
         System.out.println("Host = "      + uri.getHost());
         System.out.println("Port = "      + uri.getPort());
         System.out.println("Path = "      + uri.getPath());
         System.out.println("Query = "     + uri.getQuery());
      }
      catch (URISyntaxException e)
      {
         System.out.println(e);
      }
   }
}
