/*
   Try examples like
      >java ParseURL  https://cs.pnw.edu:80/~rlkraft/cs33600/class.html#2025-01-29
      >java ParseURL  https://google.com/search?q=pnw+cs+dept
      >java ParseURL  https://www.google.com:80
      >java ParseURL  https://swapi.dev/api/people/3/?format=json
*/

import java.net.*;

public class Parse_URL
{
   public static void main(String[] args)
   {
      final String urlString;
      if (args.length > 0)
      {
         urlString = args[0];
      }
      else
      {  // Cretae a default URL.
         urlString = "ftp://myUsername:myPassword@example.com:8042/over/there/index.php?type=animal&name=narwhal#nose";
      }

      try
      {
         final URL url = new URL( urlString );

         // See
         //     https://en.wikipedia.org/wiki/Uniform_Resource_Identifier#Example_URIs
         System.out.println("URL = " + url);
         System.out.println();
         System.out.println("Protocol = "  + url.getProtocol());
         System.out.println("Authority = " + url.getAuthority());
         System.out.println("UserInfor = " + url.getUserInfo());
         System.out.println("Host = "      + url.getHost());
         System.out.println("Port = "      + url.getPort());
         System.out.println("Path = "      + url.getPath());
         System.out.println("Query = "     + url.getQuery());
         System.out.println("File = "      + url.getFile());
         System.out.println("Anchor = "    + url.getRef());
      }
      catch (MalformedURLException e)
      {
         System.out.println(e);
      }
   }
}