/*
   Try examples like
      > java Retrieve_URL  http://cs.pnw.edu/~rlkraft/cs33600/cs33600.html
      > java Retrieve_URL  http://www.google.com
      > java Retrieve_URL  https://en.wikipedia.org/wiki/Computer_science
      > java Retrieve_URL  https://swapi.dev/api/people/3/?format=json
      > java Retrieve_URL  https://dog.ceo/api/breed/beagle/images/random
      > java Retrieve_URL  https://catfact.ninja/facts
      > java Retrieve_URL  https://cataas.com/cat/says/hello%20there?fontSize=56&fontColor=blue
*/

import java.net.*;
import java.io.*;

public class Retrieve_URL
{
   public static void main(String[] args)
   {
      final String urlString;
      if (args.length > 0)
      {
         urlString = args[0];
      }
      else
      {
         urlString = null;
         System.err.println("Usage: java Retrieve_URL <url>");
         System.exit(1);
      }

      try
      {
         final URL url = new URL( urlString );


         final BufferedReader bf = new BufferedReader(
                                       new InputStreamReader(
                                          url.openStream(), "latin1"));

         // Read the server's response.
         for (String oneLine; (oneLine = bf.readLine()) != null; )
         {
            System.out.println(oneLine);
         }
      }
      catch (MalformedURLException e)
      {
         System.out.println(e);
      }
      catch (IOException e)
      {
         System.out.println(e);
      }
   }
}
