/**
   The PrintBuffered class demonstrates how
   a buffered library function might work.

   The PrintBuffered class has a static array that is the buffer.

   The print() method appends its string to the buffer. When
   the buffer is "full" (has length > 10) the buffer is printed
   and then the buffer is "cleared".

   The flush() method can be used to force the buffer's contents to be printed.
*/
public class PrintBuffered
{
   private static String buffer = "";

   /**
      Simulate a buffer of size 10 characters.
   */
   public static void print(String str)
   {
      buffer += str;
      if (buffer.length() > 10)
      {
         System.out.print( buffer );
         buffer = "";
      }
   }

   public static void flush()
   {
      System.out.print(buffer);
      buffer = "";
   }


   public static void main(String[] args)
   {
      print("Hello");
      print(" there.\n");
      print("How are you ");
      print("doing?\n");
      //flush();
/*
      final long startTime = System.currentTimeMillis();
      for (int i = 0; i < 300_000; ++i)
      {
         print("a");
      }
      final long stopTime = System.currentTimeMillis();
      System.out.println("\nWall-clock time: " + (stopTime - startTime));
*/
   }
}
