/*
   Run this program two times. First, just run it at the
   command-line and see how long it takes to complete.

   > java TestBuffers_v3

   The run this program from the command-line and
   redirect its standard output stream to a file.

   > java TestBuffers_v3 > out3.txt

   Notice that the second time the program runs, it
   runs at least tem times faster. Why?
*/

import java.io.PrintWriter;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;

public class TestBuffers_v3
{
   public static void main(String[] args) throws Exception
   {
      final PrintWriter out = new PrintWriter(
                                  new BufferedWriter(
                                      new OutputStreamWriter(
                                          System.out, "ASCII"), 512)); // try UTF-8, UTF-16, UTF-32

      final long startTime = System.currentTimeMillis();
      for (int i = 0; i < 1_000_000; ++i)
      {
         out.println(i + " hello");
      }
      final long stopTime = System.currentTimeMillis();
      System.err.println("\nWall-clock time: " + (stopTime - startTime) + " milliseconds.");
   }
}