/**
   This program reads a search string from the command-line
   and then it reads lines from standard input and echos
   those lines that contain the search string.

   When using Windows, if standard input is the console
   keyboard, use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).
*/
import java.util.Scanner;

public class Find
{
   public static void main(String[] args)
   {
      if (0 == args.length)
      {
         System.out.println("Usage: java Find <string>");
         System.exit(-1);
      }

      final String searchTerm = args[0];

      // Create a Scanner object to make it easier to use System.in
      final Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {
         final String oneLine = scanner.nextLine();
         if (-1 != oneLine.indexOf(searchTerm))
         {
            System.out.println( oneLine );
         }
      }
   }
}
