// Illustrates CORBA callback -- sample obtained via 
// http://java.sun.com/products/jdk/1.2/docs/guide/idl/jidlExample3.html

import HelloApp.*;
import org.omg.CosNaming.*;
import org.omg.CORBA.*;
 
class HelloCallbackServant extends _HelloCallbackImplBase
{
    public void callback(String notification)
    {
        System.out.println(notification);
    }
}

public class HelloClient 
{
    public static void main(String args[])
    {
	try{
	    // create and initialize the ORB
	    ORB orb = ORB.init(args, null);
 
            // get the root naming context
            org.omg.CORBA.Object objRef = orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow(objRef);

            // resolve the Object Reference in Naming
            NameComponent nc = new NameComponent("Hello", "");
            NameComponent path[] = {nc};
            Hello helloRef = HelloHelper.narrow(ncRef.resolve(path));
 
	
	    HelloCallbackServant helloCallbackRef = new HelloCallbackServant();
            orb.connect(helloCallbackRef);

	    // call the Hello server object and print results
	    String hello = helloRef.sayHello(helloCallbackRef,"\ntest..\n");
	    System.out.println(hello);
 
	} catch (Exception e) {
	    System.out.println("ERROR : " + e) ;
	    e.printStackTrace(System.out);
	}
    }
}

