/*
                   y
                   |
                   |
                   | v5
                 3 +-----------------+ v6=(3,3,0)
                  /|                /|
                /  |              /  |
              /    |            /    |
            /      |          /      |
        v4 +-----------------+ v3    |
           |       |         |       |                    y
           |       |         |       |                    |
           |       |         |       | v7                 |
           |    v8 +---------|-------+------> x           |
           |      /          |      /3                    |
           |    /            |    /                       +-----> x
           |  /              |  /                        /
           |/                |/                         /
         3 +-----------------+                         /
         / v1=(0,0,3)        v2=(3,0,3)              z
       /
     /
    z
*/

public class MainCubes
{
   public static void main(String[] args)
   {
      // Create Model objects to hold the geometry.
      Model model1 = new Model();
      Model model2 = new Model();

      // Give each Model a color.
      model1.r = 0.0;
      model1.g = 1.0;
      model1.b = 0.0;

      model2.r = 0.0;
      model2.g = 0.0;
      model2.b = 1.0;

      // Add the geometry to the Models
      // First cube
      Vertex v1 = new Vertex(0.0, 0.0, 3.0);
      Vertex v2 = new Vertex(3.0, 0.0, 3.0);
      Vertex v3 = new Vertex(3.0, 3.0, 3.0);
      Vertex v4 = new Vertex(0.0, 3.0, 3.0);
      Vertex v5 = new Vertex(0.0, 3.0, 0.0);
      Vertex v6 = new Vertex(3.0, 3.0, 0.0);
      Vertex v7 = new Vertex(3.0, 0.0, 0.0);
      Vertex v8 = new Vertex(0.0, 0.0, 0.0);

      // Second cube.
      Vertex v9  = new Vertex(4.0, 0.0, 1.0);
      Vertex v10 = new Vertex(5.0, 0.0, 1.0);
      Vertex v11 = new Vertex(5.0, 1.0, 1.0);
      Vertex v12 = new Vertex(4.0, 1.0, 1.0);
      Vertex v13 = new Vertex(4.0, 1.0, 0.0);
      Vertex v14 = new Vertex(5.0, 1.0, 0.0);
      Vertex v15 = new Vertex(5.0, 0.0, 0.0);
      Vertex v16 = new Vertex(4.0, 0.0, 0.0);

      // First cube.
      model1.lineSegmentList.add( new LineSegment(v1, v2) ); // front face
      model1.lineSegmentList.add( new LineSegment(v2, v3) ); // front face
      model1.lineSegmentList.add( new LineSegment(v3, v4) ); // front face
      model1.lineSegmentList.add( new LineSegment(v4, v1) ); // front face
      model1.lineSegmentList.add( new LineSegment(v8, v7) ); // back face
      model1.lineSegmentList.add( new LineSegment(v7, v6) ); // back face
      model1.lineSegmentList.add( new LineSegment(v6, v5) ); // back face
      model1.lineSegmentList.add( new LineSegment(v5, v8) ); // back face
      model1.lineSegmentList.add( new LineSegment(v1, v8) ); // bottom face
      model1.lineSegmentList.add( new LineSegment(v2, v7) ); // bottom face
      model1.lineSegmentList.add( new LineSegment(v4, v5) ); // top face
      model1.lineSegmentList.add( new LineSegment(v3, v6) ); // top face

      // Second cube.
      model2.lineSegmentList.add( new LineSegment(v9,  v10) ); // front face
      model2.lineSegmentList.add( new LineSegment(v10, v11) ); // front face
      model2.lineSegmentList.add( new LineSegment(v11, v12) ); // front face
      model2.lineSegmentList.add( new LineSegment(v12, v9)  ); // front face
      model2.lineSegmentList.add( new LineSegment(v16, v15) ); // back face
      model2.lineSegmentList.add( new LineSegment(v15, v14) ); // back face
      model2.lineSegmentList.add( new LineSegment(v14, v13) ); // back face
      model2.lineSegmentList.add( new LineSegment(v13, v16) ); // back face
      model2.lineSegmentList.add( new LineSegment(v9,  v16) ); // bottom face
      model2.lineSegmentList.add( new LineSegment(v10, v15) ); // bottom face
      model2.lineSegmentList.add( new LineSegment(v12, v13) ); // top face
      model2.lineSegmentList.add( new LineSegment(v11, v14) ); // top face


      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the Models to the Scene.
      scene.modelList.add(model1);
      scene.modelList.add(model2);

      // Create a Camera object.
      Camera camera = new Camera();

      // Give the Camera a view matrix.
      camera.view2Identity();

      // Set up the camera's view frustum.
      double fov    = 60.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      camera.projPerspective(fov, aspect, near, far);
/*
      // Set up the camera's view frustum.
      double left   = -1.0;
      double right  =  1.0;
      double top    =  1.0;
      double bottom = -1.0;
      double near   =  1.0;
      double far    =  20.0;
      camera.projFrustum(left, right, bottom, top, near, far);
*/
      // Set up the camera's location and orientation.
      double eyex=0,    eyey=2,    eyez=10;
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      camera.viewLookAt(eyex,    eyey,    eyez,
                        centerx, centery, centerz,
                        upx,     upy,     upz);

      // Add the Camera to the Scene.
      scene.setCamera(camera);

      //System.err.println( scene.toString() );

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.lightGray);
      // Render our scene into the frame buffer.
      SceneRender.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_Cubes_Frame%02d.ppm", 0) );

      // Spin the models 360 degrees.
      for (int i = 1; i <= 36; i++)
      {
         // Rotate the model by 10 degrees.
         scene.camera.viewRotate(10, 0, 1, 0);
         // Render again.
         fb.clearFB(java.awt.Color.lightGray);
         SceneRender.renderScene(scene, fb);
         fb.dumpFB2File(String.format("PPM_Cubes_Frame%02d.ppm", i));
      }
   }
}