/*

*/

public class MainCylinder
{
   public static void main(String[] args)
   {
      int k = 0; // number of triangles in the triangle fans at the top and bottom
      int n = 0; // number of triangle strips between the top and bottom
      int height = 5; // the height of the cylinder

      // Check for two command line arguments.
      if (args.length >= 2)
      {
         k = Integer.parseInt( args[0] );
         n = Integer.parseInt( args[1] );
      }
      else
      {
         System.err.printf("Usage: %s <k> <n>", "MainCylinder");
         System.exit(-1);
      }

      // Create a Model object that holds the geometry.
      Model model = new CylinderModel(k, n, 1, 1);

      // Give the Model a color.
      model.r = 1.0;
      model.g = 0.0;
      model.b = 0.0;


      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the Model to the Scene.
      scene.modelList.add(model);

      // Create a Camera object.
      Camera camera = new Camera();

      // Give the Camera a view matrix.
      camera.view2Identity();
/*
      // Set up the camera's view frustum.
      double fov    = 60.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      camera.projPerspective(fov, aspect, near, far);
*/
      // Set up the camera's view frustum.
      double left   = -1.0;
      double right  =  1.0;
      double top    =  1.0;
      double bottom = -1.0;
      double near   =  1.0;
      double far    =  20.0;
      camera.projFrustum(left, right, bottom, top, near, far);

      // Set up the camera's location and orientation.
      double eyex=0,    eyey=0,    eyez=5;
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      camera.viewLookAt(eyex,    eyey,    eyez,
                        centerx, centery, centerz,
                        upx,     upy,     upz);

      // Add the Camera to the Scene.
      scene.setCamera(camera);

      //System.err.println( scene.toString(3) );

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.lightGray);
      // Render our scene into the frame buffer.
      SceneRender.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_Cylinder_Frame%02d.ppm", 0) );

      // Spin the model 360 degrees.
      for (int i = 1; i <= 36; i++)
      {
         // Rotate the model by 10 degrees.
         scene.camera.viewRotate(10, 0, 1, 0);
         // Render again.
         fb.clearFB(java.awt.Color.lightGray);
         SceneRender.renderScene(scene, fb);
         fb.dumpFB2File(String.format("PPM_Cylinder_Frame%02d.ppm", i));
      }
   }
}