/*

*/
import java.io.File;
import java.awt.Color;

public class MainObjSimple
{
   public static void main(String[] args)
   {
      // Create several Model objects.
      Model m1 = new ObjSimpleModel(new File("resources/horse.obj"));
      Model m2 = new ObjSimpleModel(new File("resources/small_rhombicosidodecahedron.obj"));
      Model m3 = new ObjSimpleModel(new File("resources/great_rhombicosidodecahedron.obj"));
      Model m4 = new ObjSimpleModel(new File("resources/apple.obj"));

      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add a model to the Scene.
      scene.modelList.add(m1);

      // Create a Camera object.
      Camera camera = new Camera();

      // Give the Camera a view matrix.
      camera.view2Identity();
/*
      // Set up the camera's view frustum.
      double fov    = 60.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      camera.projPerspective(fov, aspect, near, far);
*/
      // Set up the camera's view frustum.
      double left   = -1.0;
      double right  =  1.0;
      double top    =  1.0;
      double bottom = -1.0;
      double near   =  1.0;
      double far    =  20.0;
      camera.projFrustum(left, right, bottom, top, near, far);

      // Set up the camera's location and orientation.
      double eyex=0,    eyey=0,    eyez=8;
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      camera.viewLookAt(eyex,    eyey,    eyez,
                        centerx, centery, centerz,
                        upx,     upy,     upz);

      // Add the Camera to the Scene.
      scene.setCamera(camera);

      //System.err.println( scene.toString() );

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.lightGray);
      // Render our scene into the frame buffer.
      SceneRender.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_ObjSimple_Frame%02d.ppm", 0) );

      // Spin the scene 360 degrees.
      for (int i = 1; i <= 36; i++)
      {
         // Rotate the scene by 10 degrees.
         scene.camera.viewRotate(10, 0, 1, 0);
         // Render again.
         fb.clearFB(java.awt.Color.lightGray);
         SceneRender.renderScene(scene, fb);
         fb.dumpFB2File(String.format("PPM_ObjSimple_Frame%02d.ppm", i));
      }
   }
}