/*
                   y
                   |
                   |
                   | v[4]
                 1 +-----------------+ v[5]=(1,1,0)
                  /|                /|
                /  |              /  |
              /    |            /    |
            /      |          /      |
      v[7] +-----------------+ v[6]  |
           |       |         |       |                    y
           |       |         |       |                    |
           |       |         |       | v[1]               |
           |  v[0] +---------|-------+------> x           |
           |      /          |      /1                    |
           |    /            |    /                       +-----> x
           |  /              |  /                        /
           |/                |/                         /
         1 +-----------------+                         /
         / v[3]=(0,0,1)      v[2]=(1,0,1)            z
       /
     /
    z

   This program compares an orthographic projection to a
   perspective projection of the same cube and using all
   of the same viewing parameters.
*/

public class MainOrthographicPerspective
{
   public static void main(String[] args)
   {
      // Create a Model object to hold the geometry.
      Model model = new Model();

      // Give the Model a color.
      model.r = 1.0;
      model.g = 0.0;
      model.b = 0.0;

      // Add the geometry to the Model.
      Vertex[] v = new Vertex[8];

      v[0] = new Vertex(0.0, 0.0, 0.0);  // four vertices around the bottom face
      v[1] = new Vertex(1.0, 0.0, 0.0);
      v[2] = new Vertex(1.0, 0.0, 1.0);
      v[3] = new Vertex(0.0, 0.0, 1.0);
      v[4] = new Vertex(0.0, 1.0, 0.0);  // four vertices around the top face
      v[5] = new Vertex(1.0, 1.0, 0.0);
      v[6] = new Vertex(1.0, 1.0, 1.0);
      v[7] = new Vertex(0.0, 1.0, 1.0);

      LineSegment ls1 = new LineSegment(v[0], v[1]);
      model.lineSegmentList.add( ls1 );   // bottom face

      LineSegment ls2 = new LineSegment(v[1], v[2]);
      model.lineSegmentList.add( ls2 );   // bottom face

      LineSegment ls3 = new LineSegment(v[2], v[3]);
      model.lineSegmentList.add( ls3 );   // bottom face

      LineSegment ls4 = new LineSegment(v[3], v[0]);
      model.lineSegmentList.add( ls4 );   // bottom face

      LineSegment ls5 = new LineSegment(v[4], v[5]);
      model.lineSegmentList.add( ls5 );  // top face

      LineSegment ls6 = new LineSegment(v[5], v[6]);
      model.lineSegmentList.add( ls6 );   // top face

      LineSegment ls7 = new LineSegment(v[6], v[7]);
      model.lineSegmentList.add( ls7 );   // top face

      LineSegment ls8 = new LineSegment(v[7], v[4]);
      model.lineSegmentList.add( ls8 );   // top face

      LineSegment ls9 = new LineSegment(v[0], v[4]);
      model.lineSegmentList.add( ls9 );   // back face

      LineSegment ls10 = new LineSegment(v[1], v[5]);
      model.lineSegmentList.add( ls10 );   // back face

      LineSegment ls11 = new LineSegment(v[3], v[7]);
      model.lineSegmentList.add( ls11 );   // front face

      LineSegment ls12 = new LineSegment(v[2], v[6]);
      model.lineSegmentList.add( ls12 );   // front face

      // add three axes
      model.lineSegmentList.add(new LineSegment(v[0], new Vertex(2,0,0)));
      model.lineSegmentList.add(new LineSegment(v[0], new Vertex(0,2,0)));
      model.lineSegmentList.add(new LineSegment(v[0], new Vertex(0,0,2)));

      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the Model to the Scene.
      scene.modelList.add(model);

      // Create a Camera object.
      Camera camera = new Camera();

      // Give the Camera a view matrix.
      camera.view2Identity();

      // Add the Camera to the Scene.
      scene.setCamera(camera);

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.lightGray);



      // Set up the camera's location and orientation.
      double eyex=1.5,  eyey=1.2,  eyez=1.2;  // three point perspective proj
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      camera.viewLookAt(eyex,    eyey,    eyez,
                        centerx, centery, centerz,
                        upx,     upy,     upz);

      // Set up the camera's view volume.
      double left   = -1.0;
      double right  =  1.0;
      double top    =  1.0;
      double bottom = -1.0;
      double near   =  1.0;
      double far    =  20.0;

      // Make the view volume a frustum.
      camera.projFrustum(left, right, bottom, top, near, far);
      // Render our scene into the frame buffer using a Perspective Projection.
      SceneRender.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( "Cube_Perspective.ppm" );

      // Switch to an Orthographic Projection and rerender the scene.
      camera.projOrtho(left, right, bottom, top, near, far);
      fb.clearFB(java.awt.Color.lightGray);
      // Render our scene into the frame buffer.
      SceneRender.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( "Cube_Orthographic.ppm" );

   }
}