/*

*/
import java.awt.Color;

public class MainTorus
{
   public static void main(String[] args)
   {
      int k = 0;     // number of line segments in the circle of revolution
      int n = 0;     // number of line segments in the cross section circle
      double r1 = 0; // radius of the circle of revolution
      double r2 = 0; // radius of the cros section circle

      // Check for four command line arguments.
      if (args.length >= 4)
      {
         k = Integer.parseInt( args[0] );
         n = Integer.parseInt( args[1] );
         r1 = Double.parseDouble( args[2] );
         r2 = Double.parseDouble( args[3] );
      }
      else
      {
         System.err.printf("Usage: %s <k> <n> <r1> <r2>", "MainTorus");
         System.exit(-1);
      }

      // Create a Model object that holds the geometry.
      Model model = new TorusModel(k, n, r1, r2);

      // Give the Model a color.
      model.setColor(new Color(255, 0, 255));

      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the model to the Scene.
      scene.modelList.add(model);

      // Create a Camera object.
      Camera camera = new Camera();

      // Give the Camera a view matrix.
      camera.view2Identity();
/*
      // Set up the camera's view frustum.
      double fov    = 60.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      camera.projPerspective(fov, aspect, near, far);
*/
      // Set up the camera's view frustum.
      double left   = -1.0;
      double right  =  1.0;
      double top    =  1.0;
      double bottom = -1.0;
      double near   =  1.0;
      double far    =  20.0;
      camera.projFrustum(left, right, bottom, top, near, far);

      // Set up the camera's location and orientation.
      double eyex=0,    eyey=2,    eyez=5;
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      camera.viewLookAt(eyex,    eyey,    eyez,
                        centerx, centery, centerz,
                        upx,     upy,     upz);

      // Add the Camera to the Scene.
      scene.setCamera(camera);

      //System.err.println( scene.toString() );

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.lightGray);
      // Create a default rendering pipeline.
      SceneRender renderer = new SceneRender();
      // Render our scene into the frame buffer.
      renderer.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_Torus_Frame%02d.ppm", 0) );

      // Spin the model 360 degrees.
      for (int i = 1; i <= 36; i++)
      {
         // Rotate the model by 10 degrees.
         scene.camera.viewRotate(10, 0, 1, 0);
         // Render again.
         fb.clearFB(java.awt.Color.lightGray);
         renderer.renderScene(scene, fb);
         fb.dumpFB2File(String.format("PPM_Torus_Frame%02d.ppm", i));
      }
   }
}