/*

*/

public class MainTriangle
{
   public static void main(String[] args)
   {
      // Create a Model object to hold the geometry.
      Model model = new Model();

      // Give the Model a color.
      model.r = 0.0;
      model.g = 0.0;
      model.b = 1.0;

      // Add the geometry to the Model.
      Vertex v1 = new Vertex(3.0, 0.0, 0.0);
      Vertex v2 = new Vertex(0.0, 3.0, 0.0);
      Vertex v3 = new Vertex(0.0, 0.0, 3.0);

      LineSegment ls1 = new LineSegment(v1, v2);
      model.lineSegmentList.add( ls1 );
      LineSegment ls2 = new LineSegment(v2, v3);
      model.lineSegmentList.add( ls2 );
      LineSegment ls3 = new LineSegment(v3, v1);
      model.lineSegmentList.add( ls3 );

      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the Model to the Scene.
      scene.modelList.add(model);

      // Give the Scene a view matrix.
      scene.view2Identity();

      // Set up the scene's view frustum.
//      double fov    = 45.0;  // crash!!!!
      double fov    = 60.0;
      double aspect = 1.0;
      double near   = 1.0;
      double far    = 20.0;
      scene.projPerspective(fov, aspect, near, far);


      // Set up the scene's view frustum.
      double left   = -1.0;
      double right  =  1.0;
      double top    =  1.0;
      double bottom = -1.0;
      near   =  2.0;
      far    =  20.0;
      scene.projFrustum(left, right, bottom, top, near, far);



      // Set up the scene's "camera".
      double eyex=0,    eyey=0,    eyez=6;  // this puts vertices on the edge of the viewport
      double centerx=0, centery=0, centerz=0;
      double upx=0,     upy=1,     upz=0;
      scene.viewLookAt(eyex,    eyey,    eyez,
                       centerx, centery, centerz,
                       upx,     upy,     upz);

      //System.err.println( scene.toString() );

      // Create a framebuffer to render our scene into.
      int vp_width  = 512;
      int vp_height = 512;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.darkGray);
      // Render our scene into the frame buffer.
      SceneRender.renderScene(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( String.format("PPM_Triangle_Frame%02d.ppm", 0) );
/*
      // Spin the model 360 degrees.
      for (int i = 1; i <= 36; i++)
      {
         // Rotate the model by 10 degrees.
         scene.viewRotate(10, 0, 1, 0);
         // Render again.
         fb.clearFB(java.awt.Color.darkGray);
         SceneRender.renderScene(scene, fb);
         fb.dumpFB2File(String.format("PPM_Triangle_Frame%02d.ppm", i));
      }
*/
   }
}