/**
   A LineSegment object has two Vertex objects that represent the endpoints of the line segment.
*/
import java.util.LinkedList;

public class LineSegment
{
   public Vertex[] v = new Vertex[2]; // the vertices of this line segment

   public LineSegment()
   {
      v[0] = null;
      v[1] = null;
   }


   /**
      Create a LineSegment object whose vertices are copies of the two given Vertex objects.
   */
   public LineSegment(Vertex v0, Vertex v1)
   {
      v[0] = new Vertex(v0);  // make copies of each Vertex!
      v[1] = new Vertex(v1);
   }


   /**
      Create a LineSegment object whose vertices are copies of the two vertices from the given LineSegment object.
   */
   public LineSegment(LineSegment ls) // a "copy constructor"
   {
      v[0] = new Vertex(ls.v[0]);  // make copies of each Vertex!
      v[1] = new Vertex(ls.v[1]);
   }


   /**
      For debugging.
   */
   public String toString()
   {
      String result = "Line Segment:\n";
      result += v[0].toString();
      result += v[1].toString();
      return result;
   }
}