/**
   A Scene data structure is a list of Model data structures and a Camera data structure.

   Each Model object represents a distinct geometric object in the scene.

   The Camera object determines
     1) the location that the scene is viewed from, and
     2) the "view volume", which determines how much of the scene is actually visible to the camera.
*/
import java.util.List;
import java.util.LinkedList;

public class Scene
{
   public List<Model> modelList = new LinkedList<Model>();

   public Camera camera;


   public Scene()
   {
      this.camera = new Camera();
   }


   public Scene(Camera camera)
   {
      this.camera = camera;
   }


   public void setCamera(Camera camera)
   {
      this.camera = camera;
   }


   public void addModel(Model model)
   {
      modelList.add(model);
   }


   public String toString()
   {
      String result = "";
      result += "This Scene has " + modelList.size() + " models\n";;
      int i = 0;
      for (Model m : modelList)
      {
         result += "Model " + (i++) + "\n";
         result += m.toString();
      }
      return result;
   }
}