/**
   A Vector object holds four doubles, which makes it a vector in 4-dimensional space.

   In computer graphics, we use 4-dimensional homogeneous coordinates to represent points in 3-dimensional space.
*/

public class Vector
{
   public double x, y, z, w; /* a vector in homogenous coordinates */


   public Vector()
   {
      x = 0.0;
      y = 0.0;
      z = 0.0;
      w = 0.0;
   }


   public Vector(double x, double y, double z)
   {
      set(x, y, z, 0.0);
   }


   public Vector(double x, double y, double z, double w)
   {
      set(x, y, z, w);
   }


   public Vector(Vector v) // a "copy constructor"
   {
      set(v.x, v.y, v.z, v.w);
   }


   public void set(double x, double y, double z, double w)
   {
      this.x = x;
      this.y = y;
      this.z = z;
      this.w = w;
   }


   public Vector times(double s) // scalar times Vector
   {
      return new Vector(s*x, s*y, s*z, s*w);
   }


   public Vector plus(Vector v) // Vector addition
   {
      return new Vector( x+(v.x), y+(v.y), z+(v.z), w+(v.w) );
   }

/*
   public Vector minus(Vector v) // Vector subtraction
   {
      return new Vector( x-(v.x), y-(v.y), z-(v.z), w-(v.w) );
   }
*/

   public Vector crossProduct(Vector v)
   {
      return new Vector((y*v.z)-(z*v.y), (z*v.x)-(x*v.z), (x*v.y)-(y*v.x));
   }


   public double dotProduct(Vector v)
   {
      return x*v.x + y*v.y + z*v.z;
   }


   public Vector normalize()  // return a vector with length 1
   {
      double norm = Math.sqrt( x*x + y*y + z*z );
      return new Vector(x/norm, y/norm, z/norm);
   }


   public String toString()
   {
      // Here is one way to get programable precision and width.
      int p = 5;     // the precision for the following format string
      int t = p + 4; // the width for the folowing format string
      String format =      "[x,y,z,w] = [% "+t+"."+p+"f  % "+t+"."+p+"f  % "+t+"."+p+"f  % "+t+"."+p+"f]\n";
      return String.format( format, x, y, z, w);
    //return String.format("[x,y,z,w] = [% .5f  % .5f  % .5f  % .5f]", x, y, z, w);
   }
}