/**
   We need to make a copy of this model so that future
   pipeline stages can mutate the copy as they render it.
   (If we let the renderer mutate our original copy of this
   model, then we would not be able to re-render this model,
   say from a different view point.)

   For each Model in a Scene, walk the Model's list of
   LineSegment objects. For each LineSegment object,
   create a deep copy of the LineSegment. That means
   that we must also create a copy of each Vertex object
   in the LineSegment object.

   NOTE: This copying stage is analogous to the need for
   the CPU of a computer to copy all of the Scene data
   across a hardware bus to the computer's graphics card
   (the GPU).
*/

public class P0_CopyModel
{
   /**
      Create a new Model object that contains copies
      of all of the line segments from this model.
   */
   public static Model p0_copyModel(Model model)
   {
      Model newModel = new Model(model); // copy everything except the geometry

      // Copy all the line segments in the model's line segment list.
      for (LineSegment ls : model.lineSegmentList)
      {
         LineSegment lsCopy = new LineSegment(ls);  // deep copy
         newModel.addLineSegment( lsCopy );
      }

      return newModel;
   }
}