/**
   Convert line segments from world coordinates to view (camera) coordinates.

   For each Model in a Scene, walk the Model's list of LineSegment objects.
   For each Vertex object in each LineSgement object, use the Scene's view
   matrix to transform the Vertex object from world coordinates to view
   coordinates.
*/

public class P1_World2View
{
   /**
      For each line segment in the model, transform each
      vertex from world coordinates into view coordinates.
   */
   public static void p1_World2View(Model model, Matrix viewMatrix)
   {
      // Transform each line segment in the model's line segment list.
      for (LineSegment ls : model.lineSegmentList)
      {
         ls.v[0] = viewMatrix.times(ls.v[0]); // transform each vertex in the line segment
         ls.v[1] = viewMatrix.times(ls.v[1]);
      }
   }
}