/**
   Rasterize each line segment into pixels in the framebuffer.
*/
import java.util.LinkedList;

public class P5_Rasterize
{
   /**
      Walk the list of LineSegment objects and rasterize each line segment.

      This rasterization algorithm is from
        "Fundamentals of Computer Graphics", 3rd Edition,
         by Peter Shirley, pages 163-165.
   */
   public static void p5_Rasterize(Model model, FrameBuffer fb)
   {
      // Get the color for this model.
      int r = (int)(255*(model.r)); // convert from double to int
      int g = (int)(255*(model.g));
      int b = (int)(255*(model.b));
      java.awt.Color c = new java.awt.Color(r, g, b);

      for (LineSegment ls : model.lineSegmentList)
      {
         int x0 = (int)ls.v[0].x;
         int y0 = (int)ls.v[0].y;
         int x1 = (int)ls.v[1].x;
         int y1 = (int)ls.v[1].y;
         if (x0 == fb.getWidthVP())  x0--;
         if (y0 == fb.getHeightVP()) y0--;
         if (x1 == fb.getWidthVP())  x1--;
         if (y1 == fb.getHeightVP()) y1--;

         if (Math.abs(y1 - y0) <= Math.abs(x1 - x0)) // if abs(slope) <= 1
         {
            if (x1 < x0) // swap (x0, y0) with (x1, y1)
            {
               int tempX = x0;
               int tempY = y0;
               x0 = x1;
               y0 = y1;
               x1 = tempX;
               y1 = tempY;
            }

            double slope = (double)(y1 - y0) / (double)(x1 - x0);

            for (int x = x0; x <= x1; x++)
            {
               int y = (int)Math.round( y0 + slope*(x - x0) );
               if (y == fb.height) y--;
               fb.setPixelVP(x, y, c);
            }
         }
         else  // abs(slope) > 1
         {
            if (y1 < y0) // swap (x0, y0) with (x1, y1)
            {
               int tempX = x0;
               int tempY = y0;
               x0 = x1;
               y0 = y1;
               x1 = tempX;
               y1 = tempY;
            }

            double slope = (double)(x1 - x0) / (double)(y1 - y0);

            for (int y = y0; y <= y1; y++)
            {
               int x = (int)Math.round( x0 + slope*(y - y0) );
               if (x == fb.width)  x--;
               fb.setPixelVP(x, y, c);
            }
         }
      }
   }
}