/**
   This is the "rendering pipeline".

   This program takes as its input a Scene data structure
   and it produces, as its output, a filled in FrameBuffer
   data structure. The final FrameBuffer holds the rendered
   image of the scene represented by the Scene object.
*/

public class SceneRender
{
   public static void renderScene(Scene scene, FrameBuffer fb)
   {
      for (Model model : scene.modelList)
      {
         printVertices(model, 0);

         // duplicate the model
         Model model2 = P0_CopyModel.p0_copyModel(model);

         printVertices(model2, 1);

         // apply the view transformation
         P1_World2View.p1_World2View(model2, scene.camera.viewMatrix);

         printVertices(model2, 2);

         // apply the projection transformation
         P2_View2Clip.p2_View2Clip(model2, scene);

         printVertices(model2, 3);

         // clip line segments to the standard volume
         P3_Clipping.p3_Clipping(model2);

         printVertices(model2, 4);

         // transform normalized device coordinates to viewport coordinates
         P4_NDC2VP.p4_NDC2VP(model2, fb.getWidthVP(), fb.getHeightVP());

         printVertices(model2, 5);

         // rasterize each line segment into pixels
         P5_Rasterize.p5_Rasterize(model2, fb);
      }
   }//renderScene()


   /**
      Used for debugging.
   */
   public static void printVertices(Model model, int stageNo)
   {
      int stageFlag = 1;
      for (int i = 0; i < stageNo; i++)
         stageFlag = stageFlag << 1;  // shift the 1 bit into the correct position

      int debugStages = 0;
      String debugString = null;
      if ( (debugString = System.getenv("PipeLine0")) != null ) debugStages += 1;
      if ( (debugString = System.getenv("PipeLine1")) != null ) debugStages += 2;
      if ( (debugString = System.getenv("PipeLine2")) != null ) debugStages += 4;
      if ( (debugString = System.getenv("PipeLine3")) != null ) debugStages += 8;
      if ( (debugString = System.getenv("PipeLine4")) != null ) debugStages += 16;
      if ( (debugString = System.getenv("PipeLine5")) != null ) debugStages += 32;

      if ((stageFlag & debugStages) != 0)
      {
         System.err.printf("================= Stage P%d begin ===========\n", stageNo);
         System.err.print( model.toString() );
         System.err.printf("================= Stage P%d end =============\n", stageNo);
      }
   }//printVertices()
}