/**
                  v[4]
                   +-----------------+ v[5]
                  /|                /|
                /  |              /  |
              /    |            /    |
            /      |          /      |
      v[7] +-----------------+ v[6]  |
           |       |         |       |               y
           |       |         |       |               |
           |       |         |       |               |
           |  v[0] +---------|-------+ v[1]          |
           |      /          |      /                |
           |    /            |    /                  +----. x
           |  /              |  /                   /
           |/                |/                    /
           +-----------------+                    /
          v[3]              v[2]                 z

   xs the size of the cube along the x-axis
   ys the size of the cube along the y-axis
   zs the size of the cube along the z-axis
*/

public class CubeModel extends Model
{
   public CubeModel(double xs, double ys, double zs)
   {
      super();

      // Create the cube's geometry.
      Vertex[] v = new Vertex[8];
      v[0] = new Vertex(0,    0,    0);      // four vertices around the bottom face
      v[1] = new Vertex(0+xs, 0,    0);
      v[2] = new Vertex(0+xs, 0,    0+zs);
      v[3] = new Vertex(0,    0,    0+zs);
      v[4] = new Vertex(0,    0+ys, 0);      // four vertices around the top face
      v[5] = new Vertex(0+xs, 0+ys, 0);
      v[6] = new Vertex(0+xs, 0+ys, 0+zs);
      v[7] = new Vertex(0,    0+ys, 0+zs);

      // Create 12 line segments
      LineSegment[] ls = new LineSegment[12];

      int i = 0;
      // bottom face
      ls[i++] = new LineSegment(v[0], v[1]);
      ls[i++] = new LineSegment(v[1], v[2]);
      ls[i++] = new LineSegment(v[2], v[3]);
      ls[i++] = new LineSegment(v[3], v[0]);

      // top face
      ls[i++] = new LineSegment(v[4], v[5]);
      ls[i++] = new LineSegment(v[5], v[6]);
      ls[i++] = new LineSegment(v[6], v[7]);
      ls[i++] = new LineSegment(v[7], v[4]);

      // back face
      ls[i++] = new LineSegment(v[0], v[4]);
      ls[i++] = new LineSegment(v[1], v[5]);

      // front face
      ls[i++] = new LineSegment(v[3], v[7]);
      ls[i++] = new LineSegment(v[2], v[6]);

      // Add the new line segments to the scene.
      for (i = 0; i < ls.length; i++)
      {
         this.addLineSegment( ls[i] );
      }
   }
}//CubeModel