/**
   k number of triangles in each triangle fan at the top and bottom
   n number of rectangle strips between the top and bottom triangle fans
   r radius of the cylinder
   h height of the cylinder
*/

public class CylinderModel extends Model
{
   public CylinderModel(int k, int n, double radius, double h)
   {
      super();

      // Create the cylinder's geometry.

      // An array of vertices to be used to create line segments.
      Vertex[][] v = new Vertex[n+1][k];

      // Create all the vertices along the cylinder wall.
      for (int j = 0; j < k; j++)
      {
         double c = Math.cos(j*(2.0*Math.PI)/k);
         double s = Math.sin(j*(2.0*Math.PI)/k);
         for (int i = 0; i <= n; i++)
         {
            v[i][j] = new Vertex( radius*c, h-i*((2.0*h)/n), radius*s );
         }
      }
      // Vertex at the center of the top.
      Vertex topCenter = new Vertex(0.0, h, 0.0);
      // Vertex at the center of the bottom.
      Vertex bottomCenter = new Vertex(0.0, -h, 0.0);


      // Create all the horizontal circles of latitude around the cylinder wall.
      LineSegment ls;
      for (int i = 0; i <= n; i++)
      {
         for (int j = 0; j < k-1; j++)
         {
            ls = new LineSegment( v[i][j], v[i][j+1] );
            this.addLineSegment( ls );
         }
         ls = new LineSegment( v[i][k-1], v[i][0] );
         this.addLineSegment( ls );
      }

      // Create the vertical lines from the top to the bottom.
      for (int j = 0; j < k; j++)
      {
         ls = new LineSegment( v[0][j], v[n][j] );
         this.addLineSegment( ls );
      }

      // Create the triangle fan at the top.
      for (int j = 0; j < k; j++)
      {
         ls = new LineSegment( topCenter, v[0][j] );
         this.addLineSegment( ls );
      }

      // Create the triangle fan at the bottom.
      for (int j = 0; j < k; j++)
      {
         ls = new LineSegment( bottomCenter, v[n][j] );
         this.addLineSegment( ls );
      }
   }
}//CylinderModel