/**
   A flat checkerboard in the xz-plane.
*/
import java.awt.Color;

public class PanelModel extends Model
{
   public PanelModel(int xMin, int xMax, int zMin, int zMax)
   {
      super();

      // Create the line segments that run in the z-direction.
      for (int x = xMin; x <= xMax; x++)
      {
         LineSegment ls = new LineSegment(new Vertex(x, 0, zMin),
                                          new Vertex(x, 0, zMax));
         this.addLineSegment( ls );
      }

      // Create the line segments that run in the x-direction.
      for (int z = zMin; z <= zMax; z++)
      {
         LineSegment ls = new LineSegment(new Vertex(xMin, 0, z),
                                          new Vertex(xMax, 0, z));
         this.addLineSegment( ls );
      }
   }
}