/**
   A flat checkerboard in the xz-plane.
*/
import java.awt.Color;

public class PanelModel_v2 extends Model
{
   public PanelModel(int xMin, int xMax, int zMin, int zMax)
   {
      super();

      // Create the checkerboard's geometry.
      Vertex[][] v = new Vertex[(xMax-xMin)+1][(zMax-zMin)+1];

      for (int x = xMin; x <= xMax; x++)
         for (int z = zMin; z <= zMax; z++)
         {
            v[x-xMin][z-zMin] = new Vertex(x, 0, z);
         }

      // Create the line segments that run in the z-direction.
      for (int x = 0; x <= xMax-xMin; x++)
      {
         for (int z = 0; z < zMax-zMin; z++)
         {
            LineSegment ls = new LineSegment( v[x][z], v[x][z+1] );
            this.addLineSegment( ls );
         }
      }

      // Create the line segments that run in the x-direction.
      for (int z = 0; z <= zMax-zMin; z++)
      {
         for (int x = 0; x < xMax-zMin; x++)
         {
            LineSegment ls = new LineSegment( v[x][z], v[x+1][z] );
            this.addLineSegment( ls );
         }
      }
   }
}